# Al in marketing, consumer research and psychology: A systematic literature review and research agenda

Marcello M. Mariani1,2

Rodrigo Perez-Vega³ $\textcircled{1}$ 丨 Jochen Wirtz4 $\textcircled{1}$

1Henley Business School, University of Reading,Reading,UK 2Universityof Bologna,Bologna,Italy 3Kent Business School, University of Kent, Medway Campus, Chatham, UK 4NUS Business School, National Univeristy of Singapore,Singapore, Singapore

# Correspondence

Marcello M.Mariani,Henley Business School, University of Reading,Reading RG6 6UD,UK. Email: m.mariani@henley.ac.uk

# Abstract

This study is the first to provide an integrated view on the body of knowledge of artificial inteligence (Al) published in the marketing, consumer research,and psychology literature. By leveraging a systematic literature review using a data-driven approach and quantitative methodology (including bibliographic coupling), this study provides an overview of the emerging intellectual structure of Al research in the three bodies of literature examined. We identified eight topical clusters: (1) memory and computational logic; (2) decision making and cognitive processes; (3) neural networks; (4) machine learning and linguistic analysis; (5) social media and text mining; (6) social media content analytics; (7) technology acceptance and adoption; and (8) big data and robots. Furthermore,we identified a total of 412 theoretical lenses used in these studies with the most frequently used being: (1) the unified theory of acceptance and use of technology; (2) game theory; (3) theory of mind; (4) theory of planned behavior; (5) computational theories; (6) behavioral reasoning theory; (7) decision theories; and (8) evolutionary theory. Finally，we propose a research agenda to advance the scholarly debate on Al in the three literatures studied with an emphasis on cross-fertilization of theories used across fields,and neglected research topics.

# KEYWORDS

artificial inteligence, Al, big data and robots, decision making and cognitive processes, machine learning and linguistic analysis, memory and computational logic, neural networks, social media contentanalytics,social mediaandtextminingsystematicliteraturereview,technology acceptance and adoption

# 1 INTRODUCTION

The field of artificial intelligence (Al) is experiencing a second renaissance since computers appeared first in the 195Os (Tan & Lim, 2018).This is partly explained by advances in computing and big data capabilities which enabled computer scientists to develop algorithmic models that can identify patterns and learn in real time.Today,Al applications go beyond purely computing fields and are deployed in a rapidly increasing number of contexts and devises.These include smartphones (Makridakis,2O17),recommender systems (Zhang et al., 2021),and customer service (Belanche et al., 2O2O; Lu et al., 2020; Wirtz et al.,2O18). They even take on advanced roles in fields that were previously considered to be reliant on human intellect such as in journalism (Carlson,2O15), creative roles like painting (Quackenbush,

2018) and music production (Marshall, 2018), (Tufekci, 2015) and marketing (Sterne,2017).

While Al is experiencing exponential growth in adoption by marketing managers and consumers,to the best of our knowledge, there is no study covering comprehensively and holistically the body of knowledge produced on Al in the closely related fields of marketing, consumer research,and psychology.This is surprising as the psychological underpinnings of Al adoption in consumer behavior and use of Al in marketing are often tightly related to research in the broader psychology field.Furthermore,the importance of understanding psychological processes to the field of Al is evident.Scientists that began working on Al had the ultimate goal to develop machines that could perform a task that,if conducted by a human, would require intelligence (McCarthy et al.,2OO6).Therefore,an understanding of how cognitive processes can be replicated by algorithms has become essential.The link with the field of marketing is also critical as marketing represents one of the most important application areas for Al (Sterne,2O17).Accordingly,this literature reviewaims to answer the following research question:

What is the intellectual structure of the marketing,consumer research,and psychology literature related to Al?

To address our research question, the paper is organized as follows.Section 2 reviews the conceptual underpinnings and sheds light on the recent debate on Al in the three fields of study.Section 3 describes the methodology and research design.Section 4 discusses our findings regarding the descriptive analysis,keyword occurrence, the themes that emerged from the bibliographic coupling analysis, the theoretical lenses used in the three literatures,and emerging theories.Section 5 presents suggestions for further research.

# 2I CONCEPTUAL UNDERPINNINGS AND RECENT DEBATE ON AI IN MARKETING

This paper aims to map the intellectual structure of three areas of marketing,consumer research,and psychology knowledge in relation to Al.Therefore,this section defines the conceptual underpinnings of Al ineach of these fields to inform this systematic literature review (SLR).

Marketing is defined as the activity,set of institutions,and processes for creating,communicating,delivering,and exchanging offerings that have value for customers,clients,partners,and society at large (American Marketing Association,2O17).Marketing as a discipline has evolved due to rapid technological changes.In its research priorities for 202O-2022,the Marketing Science Institute describes Al as an important technology that has impact on the capabilities and accountability of marketing management and in the optimization of marketing functions and strategies (Marketing Science Institute,2020).

Consumption,consumer studies,and consumer research are fundamental parts of contemporary society and of interest not only to marketers,but also to policy makers and other research disciplines (Maclnnis et al.,2O2O). There is a variety of interactions that consumers currently have with Al.Marketing researchers recognize that

Al offers important potential benefits for consumers and their lives (e.g.,Pitardi et al.,2O21).However, there are also inherent tensions the increased use of Al can have on consumers,which include privacy concerns,dehumanization,and even addiction (Lobschat etal., 2021; Puntoni et al., 2021).

The field of psychology emerged early onas discipline of great importance to the investigation of behavior in the marketplace and marketing science (Alderson,1952).Psychology focuses on the study of the mind and how it influences our behaviors,and ranges from communications，memory，and decision making，to perceptions, thought,and emotions (British Psychological Society,2O21).Despite the fact that marketing has drawn on several social science disciplines suchas sociology and cultural anthropology，psychological theories remain at the core of consumer behavior and marketing research.

The intersection between marketing，consumer research,and psychology has been underpinned historically by the shift from using mostly economic models to explain consumer choice to a focus on psychological theories.These psychological theories draw on models fromsocial psychology，motivational psychology，environmental psychology,and education psychology (Hansen,1976). By embracing theories from psychology and other social sciences,consumer research has increasingly focused on gaininga deeper understanding of the thinking,desires,and experiences of individual consumers (Malter et al., 2020).

Al has been defined as“the use of computational machinery to emulate capabilities inherent in humans,such as doing physical or mechanical tasks,thinking,and feeling"(Huang& Rust,2O21,p.31). Historically,Al emerged almost at the same time as the first computers,but more recently,Al has gained momentum as new applications are possible due to rapid advances in computer power and a wide range of technologies (e.g., computer vision, machine learning, and natural language processing),and an explosion of available data to train algorithms (Bornet et al., 2021).

The increasing relevance of Al in marketing is witnessed by the emergence of several literature reviews on the topic.For example, Mustak et al. (2O21) conducted topic modeling using natural language processing.They identified ten research topics in the area of marketing and Al that were later classified in relation to two major pillars: (1) consumer research,and (2) organization and strategy-related research.Vlacic et al. (2O21) reviewed the literature on Al/intelligent systems and marketing using content analysis combined with multiple correspondence analysis procedures and identified four themes: (1) marketing channels,(2) marketing strategy,(3) performance,and (4) segmentation,targeting and positioning.

Our study is distinctively different compared to past literature reviews and makes the following contributions.First,our article is the first to focus on Al in the interrelated fields of marketing,consumer research and psychology,and provides an integrated view of these three streams of literature.Second,in addition to adopting bibliometric techniques,we examine the overarching intellectual structure emerging from the three steams of literature,and therefore,move beyond traditional disciplinary boundaries and look at the multidisciplinary linkages and dialogue between the three fields.Third,and as a corollary of the previous point,we identify and discuss the wide range of theoretical lenses adopted in this multidisciplinary area to facilitate a better understanding of Al research.

article citations,and number of citing articles with and without selfcitations)，journal sources,keywords,countries and regions,and author-level metrics (c.f., Martynov et al.,2020).

# 3I METHOD AND DATA

To generate an up-to-date overview of existing research on Al in marketing，consumer research,and psychology，and assess quantitatively the related literature,we carried out a SLR.SLRs are considered the appropriate tool to systematicallyassess and evaluate a given body of literature (Ginsberg & Venkatraman，1985).Additionally,as a comprehensive,structured,and analytical means of accurately organizing reviews,a SLR is an effective method to identify research gaps (Klassen etal.,1998; Paul & Criado,202O).Widely adopted in social sciences (Tranfield etal.,2Oo3),management,and marketing research (Christofi et al.,2O21;Paul & Feliciano-Cestero, 2021),a SLR offers a number of benefits,including the ability to construct flexible databases of articles that can easily be updated and interrogated (Pickering& Byrne,2014).

Data for our SLR was extracted and gathered from Scopus,one of the most comprehensive sources of indexed academic publications.It covers articles published since 1966,indexing 12,850 journals in fields such as physical sciences,health sciences,life sciences, and of course,social sciences (Archambault et al., 2Oo9). Scopus was chosen over Web of Science for two reasons.First,as scholars face a trade-off between data coverage and cleanliness, Scopus has been found to havea larger coverage ( $60 \%$ larger) than WoS (Zhao & Strotmann,2O15).Second,SLRs and bibliometric studies in social sciences typically deploy only on one database to mitigate data homogenization issues faced when working with multiple databases (e.g., Galati & Bigliardi, 2019).

To search the database,we first identified a set of keywords related to Al in our three fields of study.Specifically,in line with a recent literature review of Al in marketing (Mustak et al., 2O21) the keywords identified were:“Al,”“artificial intelligence,”“machine learning,”“robot,”“automation,”“big data,”“neural network\*,”“natural language processing,”“data mining,”“text mining,”“soft computing,”“fuzzy logic,”“biometrics,”"geotagging,”“wearable\*,”“loT," "Internet of Things,”"chatbot,”“smart technologies,”“Al service robots,”and“autonomous vehicles."

We ran a query using a combination of these keywords (adopting the Boolean operator ${ } ^ { " } \mathrm { O R } ^ { \prime \prime } .$ inthe fieldsrelatedto“title,”"abstract," and “keywords."We took into account works published until June 15, 2021.We then narrowed down the sample by examining its intersection with the keywords “marketing,”"consumer\*,”and “psycho$\mathsf { l o g } ^ { * }$ .”After excluding proceedings，book chapters，books，and materials not published in English,and confining the search to the subject areas “Business,Management and Accounting"and “Psychology,"the search yielded 4488 articles.

Finally,we retrieved the metadata for these 4,488 articles which included author names,titles,country of corresponding author,total number of publications,citation counts (i.e.,total citations,average

# 4I ANALYSIS AND FINDINGS

Theanalysis section first presents the descriptive analyses,followed by the analyses of key word occurrence and co-occurrence.The final section examines the theoretical lenses used across the three literature fields.

# 4.1丨Descriptive analyses

In this section,we provide a descriptive analysis of the sample obtained through our SLR queries.For this analysis,we used number of publications as proxy for research productivity (e.g.,by country and journal) and the number of citations for research impact.

# 4.1.1丨 Publications by year

We plotted the evolution of publications on the topic of Al in our three fields over time from 1972 to June 2021.Figure 1 presents this evolution which suggests a rapid and exponential growth over the last decade which testifies to the growing scholarly interest in the topic. We note that the majority of publications of the topic $( 5 3 . 7 \%$ of 4497 articles) are accounted from the period of 2017 to June 2021.

# 4.1.2丨 Publications by country

Our query collected publications from 72 different countries.A holistic illustration of the countries by number of articles published is shown in Figure 2.The top 1O countries are shown in Table 1,with the United States,the UK,and China in the top three.This seems to largely mirror the technological achievements of these countries,which is potentially driven by their large scale governmental funding and industrial policies that support investments in Industry 4.O technologies in general and Al in particular.According to recent academic and industry research, the United States hosts the largest Al service providers (UNCTAD,2021), China and the United States are home to the most Al professionals (Rayome,2O19),and all of the top 2O countries in terms of Al publications are also those in the top 2O countries in terms of technologies readiness index (UNCTAD,2021).

# 4.1.3丨 Publishing activity by journal

Journals publishing on Al in our three fields are listed in Table S1. They include a range of psychology journals (e.g.,Frontiers in Psychology，Psychological Review，Frontiersin Human Neuroscience,

![](images/ee67692d4fd49fec19184b5d6ff55382e2ba3c60be3652aa0cc3315c44165892.jpg)  
FIGURE1NumberofpublicationsperyearonAlinmarketingandpsychology.Thenumberofpublicationsfor2020onlyshowsthefirst monthsof theyearand suggestsadramaticoverallincrease for 2O2Oovertheprevious year.Al,artificial intellgence

![](images/0e9dd93c970059f51bef4f1a9a70605c7db4a2bc068d0875d62b17b9b231d9c9.jpg)  
FIGURE2CountriesthathavepublishedonAlwithin marketing,onsumerresearch,andpsychology.Al,artificialinteligence

Behavioural and Brain Science,Journal of Experimental Psychology: Human Perception and Performance), journals focusing on humancomputer interaction (e.g.,Computers in Human Behavior),computer systems(e.g.,Decision Support Systems,International Journal of Recent Technology and Engineering,Knowledge-Based Systems,Cognitive Systems Research)，marketing (e.g.，Journal of Retailing and Consumer Services,Industrial Marketing Management,Marketing Science，Psychologyand Marketing,Journal of Marketing,Applied Marketing Analytics), business research (e.g.,Journal of Business Research),and sector specific journals (e.g.,Tourism Management).

It is interesting to note that it is journals in psychology and human-computer interactions that have played a key role in the advancement of research in Al,which are then followed by journals in computer and information systems, then business and marketing journals.

# 4.2| Keyword co-occurrence and co-occurrence networks

Previous bibliometric work has conducted keyword analyses to determine the content of articles and the main themes that are examined in an area of knowledge (Comerio & Strozzi, 2O19).In this study we performed keyword co-occurrence analysis aimed at identifying keyword co-occurrence networks (Radhakrishnan et al., 2017).Keywords co-occurrence analyses allow to graphically represent and understand the knowledge structure of a scientific field by examining the links between keywords.Co-occurrence analysis explores implicitly the relationships that authors in research papers make when they select the keywords for their manuscripts (Su & Lee,2O1O).Therefore,in our analysis,the keywords found in the same keyword co-occurrence networks are the ones that are conceptually close，while proximity to other keyword co-occurence networks and keywords can be regarded as how close those two concepts are to each other. The results of our keyword cooccurrence analysis is shown in Figure 3.As is shown in Figure 3,the concepts of Al, big data and machine learning are central and closely interrelated.However, they are also connected to each of the other keyword co-occurrence networks.The keyword co-occurrence networks related to neural networks are more isolated and closely related to elements of learning memory,and decision making,which in turn link to marketing management functions such as market segmentation and customer relationship management.

TABLE 1 Top 10 countries by number of documents   

<html><body><table><tr><td> Ranking</td><td> Country</td><td> Documents</td><td> % Documents</td><td> Citations</td><td> % Citations</td></tr><tr><td>1</td><td> United States</td><td>1,622</td><td>29</td><td>61,818</td><td>42</td></tr><tr><td>2</td><td>UK</td><td>552</td><td>10</td><td>17,500</td><td>12</td></tr><tr><td>3</td><td>China</td><td>301</td><td>5</td><td>5197</td><td>3</td></tr><tr><td>4</td><td> India</td><td>264</td><td>5</td><td>1635</td><td>1</td></tr><tr><td>5</td><td>Germany</td><td>252</td><td>4</td><td>6907</td><td>5</td></tr><tr><td>6</td><td> Australia</td><td>237</td><td>4</td><td>7350</td><td>5</td></tr><tr><td>7</td><td>Canada</td><td>202</td><td>4</td><td>4496</td><td>3</td></tr><tr><td>8</td><td> Italy</td><td>181</td><td>3</td><td>3801</td><td>3</td></tr><tr><td>9</td><td>France</td><td>139</td><td>2</td><td>3087</td><td>2</td></tr><tr><td>10</td><td> Netherlands</td><td>135</td><td>2</td><td>4252</td><td>3</td></tr></table></body></html>

As part of the keyword co-occurrence analysis,we were able to determine those keywords with the highest levels of occurrences and this is represented by the size of the circles in the visual representation of our co-occurrence analysis.We used the keywords with the highest occurrence in each keyword co-occurrence networks to name the keyword co-occurrence networks in our analysis: Big data,machine learning,Al,data mining,neural networks,marketing，and e-commerce.We discuss each of the keyword cooccurrence networks next, presented in order of occurrence.

# 4.2.1Big data

Big data is a term used to describe data that due to its volume, rapidity in generation,and its diversity in terms of variety of data types provides marketers with an important area of opportunity to inform decision making (Erevelles et al.,2O16).Big data has four characteristics (commonly referred as the 4Vs):volume (from terabytes to petabytes),velocity (cross-sectional data to high frequency stream data),variety (numeric, text,images,video,sound,etc.),and veracity (reliability and validity；Wedel& Kannan,2O16).Erevelles et al. (2O16) highlight that due to the high adoption of technological devices,consumers have become constant producers of traditional, structured,and transactional data as well as more contemporary, unstructured,and behavioral data.Applications of big data include establishing customer-centric marketing,developing and provisioning vehicle-data-driven services,and optimizing production processes by creating highly accurate virtual representations of production facilities (e.g.,car manufacturing) and using real time data to minimize production costs (Dremel et al.,2020).

# 4.2.2丨 Machine learning

Machine learning is defined asa“computational strategy that automatically determines (i.e., learns) methods and parameters to reach an optimal solution to a problem rather than being programmed by a human a priori to delivera fixed solution"(Dwyer et al.,2O18,p.94). Machine learning is considered a subfield of Al as the learning process mimics a facet of human intelligence (Domingos, 2017).

There are numerous advantages associated to machine learning that academics in many fields have identified. For instance,in the field of psychology,machine learning methodologies and theory are considered to have the potential to move away from mainly explanatory theories and models to more predictive ones (Yarkoni & Westfall,2O17). Similar expectations are also seen in the field of marketing,where early evidence on application of machine learning techniques in marketing activities (e.g.,in direct marketing campaigns) have witnessed improvements in forecasting models,therefore assisting marketers with decision making (Cui et al., 2006).

# 4.2.3丨Artificial intelligence

Al refers to programs,algorithms,systems and machines that demonstrate intelligence (Shankar,2O18,p.vi). Since its early days,Al has had the ultimate goal to mimic intelligent human behavior (Syam & Sharma,2O18). Huang and Rust (2O18)advance that there are four types of Al,namely mechanical (i.e.,，automation)，analytical (i.e., propensity modeling)，intuitive (e.g，generation of content)，and empathetic (i.e.,social robotics). Davenport etal.(2O2O)argue that Al will transform business models,sales processes,customer service, and consumer behavior.Changes in business models are anticipated to change how some industries structure their business models.For instance,in the context of retailing advancements in predictive analytics could mean a change from shopping and then shipping to a model where shipping is done first as predictive models are able to anticipate a purchase before it occurs.Changes in sales processes involve the use of real-time feedback to feed changes in sales pitches and communication materials.There are high expectations in terms of Al-enabled systems facilitating personalization of customer experiences (Kumar et al., 2O19)and helping marketers use a wide variety of solicited and unsolicited form of customer engagement to improve marketing outcomes (Perez-Vega et al.,2O21). Finally,changes in consumer behavior are related to the adoption of Al-enabled technologies for aspects related to information search as well as behavioral changes derived from advancements in technology (e.g., the implications on consumer behavior once self-driving cars become prevalent).

![](images/9fa503bac41f33d089cb55fa3ba3fb66aba72252b82adc963e4519de3716118f.jpg)  
FIGURE3Keyordcccurenceetworksinlesearchinthefieldsofarketigonsumereaviondpsyhogyrtiial intelligence

# 4.2.4| Data mining

Data mining is the process of searching and analyzing data to detect implicit，but potentially useful, information (Berry & Linoff,2004). Outcomes from data mining have improved due to developments in database processing，data warehousing，machine learning，and knowledge management (Shaw et al.,2OO1).Applications of data mining in marketing can be used for discovery,predictive modeling, and forensic analysis (Rygielski et al.，2OO2).Discovery involves looking into a database to identify hidden patterns without predetermined idea of what the patterns might be.Predictive modeling involves taking discovered patterns to predict future outcomes. Finally,forensic analysis uses extracted patterns to identify anomalous or unusual data elements (Rygielski et al., 2002).

# 4.2.5丨 Neural networks

A neural network (also known as an artificial neural network)is computer software that simulates human intelligence to deduce or learn from a data set (Law & Au,1999).In the context of neural computing，neural networks are used for pattern recognition and make use of feed-forward network architectures such as the multilayer perceptron (a computational method that efficiently evaluate the iterative procedures that algorithms perform to reduce errors) and the radial basis function network (an alternative training method for algorithms to form links between disparate concepts；Bishop, 1995). Cortez et al. (2OO9) highlight that due to improvements in IT capabilities,it is possible to collect,store and process highly complex datasets. Neural networks have emerged as one of the data mining algorithms used to analyze this data. Through such data mining, managers aim to extract high-level knowledge by identifying trends and patterns which can then be used to improve decision making (Turban et al.2Oo8). Other techniques to derive meaning from neural networks are linear/multiple regression and support vector machines (Cortez et al., 2009).

# 4.2.6Marketing

As it would be expected in a SLR that focuses on the structure of knowledge related to marketing and Al,marketing as a theme emerged as a prominent topic.Research related to understanding how consumers make Al-supported decisions were highly cited. Notably，Hauser (2O14） provided evidence of consumers using heuristic decision rules to select the products in their consideration set and the role of Al in supporting this decision making.In relation to this,the use of big data is also identified as an opportunity to better understand consumer behavior (Filieri & Mariani,2O21；Hofacker et al.,2O16).Furthermore,empirical work found that using online promotional marketing and online reviews can be useful at predicting future product demand (e.g.,Chong et al., 2O17).Another prominent theme relates to marketing automation to attract customers,and build and maintain relationships with current and prospective customers (Järvinen& Taiminen,2O16).Marketing automation exploits both active and passive means of learning about potential buyers. Active approaches involve directly asking questions,and passive approaches involve utilizing information on past transactions or clickstream data.

# 4.2.7| E-commerce

E-commerce has emerged as a prevalent sales and service channel for many businesses (Chiang et al.,2OO6; Grewal et al., 2018) and has become an important context for research on data mining,business intelligence,and customer relationship management systems (Phan $\&$ Vogel,2O1O).Many e-commerce websites also use recommender systems that rely on algorithms and machine learning to recommend new products to customers and improve the transactions on these platforms (Guo et al., 2017).

# 4.3丨Themes from bibliographic coupling

Bibliographic coupling is a technique that measures the similarity between articles by capturing the number of shared references (Kessler,1963).The references cited in an article help explain the topic and,as such,articles citing the same references are linked (Perianes-Rodriguez et al., 2O16). Benefits of bibliographic coupling include the ability to provide visualization maps based on the most cited papers,presenting insights for current research concerns,and guidelines for upcoming research (Jones & Gatrell, 2014).

We conducted a bibliographic coupling analysis of articles,authors,and journals to create structure maps and present a clear picture of the evolution of scientific production on the focal topic of Alinour three scientific fields (c.f., Boyack& Klavans,2O1O;Mariani & Borghi,2O19；Mariani et al.，2021；Mariani & Baggio，2021; Pritchard,1969; Zupic & Cater 2015). Specifically,we employed VOs using the VOSviewer package of Van Eck and Waltman (2009) to generate bibliometric maps,which has been widely adopted in the literature (e.g.,Apriliyanti & Alon,2017； Ferreira,2018).VOS has been found to be superior to multidimensional scaling to build bibliometric maps (Van Eck et al., 2O1O),and we therefore did not involve multidimensional scaling.

We carried out bibliographic coupling by using articles as units of analysis and settinga threshold of at least 1OO citations per paper. This produced eight clusters from 198 documents.Figure 4 illustrates the eight clusters and their main themes.The clusters to the right side (clusters 1-3), just like the right hemisphere of the human brain,focus mainly on memory and reasoning,and general cognitive processes. Those in the center (clusters 4 and 8) focus on specific aspects of how cognitive processes are translated into machine settings,as it is with the case of robotics and machine learning.Finally,the left side of the figure (clusters 5-7) shows the interaction between technology and humans and consumer psychology.These range from the acceptance,adoption and use of Al technology to analyzing consumer psychology using content analytics and text mining.The following sections explore each of these clusters in more detail.

# 4.3.1丨 Memory and computational logic

Cluster 1 focuses on different cognitive processes that humans can perform and some of the tools that are available for computers to replicate them.For instance,Wilson (1988) developed a machineusable dictionary for experimentation in psycholinguistics.The dictionary also supported early applications of Al to create psychological and linguistic descriptions of words that could be understood and processed by machines.In a similar vein,Perry etal.(2OO7)offer an analysis of different computational models used for reading and word recognition.

![](images/00d04e5083009240d615caaae4e93c04f781e98135c4d08dab02ff294facafe4.jpg)  
FIGURE 4Clusters identified through bibliographic coupling

Notable to the field of computational logic is the work of Thagard (1989) that introduced a computational theory of explanatory coherence that can explain causal reasoning,enable the rejection or acceptance of scientific hypotheses,and process everyday life decisions.The theory introducesa series of seven principles that are used to establish relationships between hypotheses and other propositions.The theory suggests that a hypothesis is coherent with the propositions that it explains,or that explain it.Propositions describing the results of observation havea degree of acceptability,but propositions are incoherent with each other if they are contradictory.Thagard's (1989) work has contributed greatly to the development of expert systems by offering a conjecture between psychological and technological applicability of different causal reasoning techniques.

Other articles in this cluster focus on additional human cognitive processes that could be replicated by machines.For instance, Pylyshyn (1999) described how visual perception can be operationalized in computers and engaged in the debate on whether vision was indeed a cognitive process or a separate process from cognition.Human vision involves human brain processing an immense amount of sensory inputs and the activation of mechanisms to make sense of the visual inputs,including selective attention that helps the brain to prioritize differently the visual inputs (Frintrop et al.,2O1O). In the context of computer vision,computer systems and robots must also process millions of pixel values and given that visual perception is not separated from cognition,it is important to endow machines and robots with multiple sensors when performing visual tasks (Frintrop et al.,2010).

While the inputs of vision are pixel values in the context of robots,the output of vision would consist of shape representations entailingat least surface layouts,edges and further details sufficiently rich to allow parts to be looked up in a shape-indexed memory to identify known objects，as was suggestedby Pylyshyn (1999).

# 4.3.2丨 Decision making and cognitive processes

Some of the most prominent articles in cluster 2 focus on purely cognitive processes that are relevant to understand how the human brainperforms.For example,Everitt and Robbins (1997) examined the different functions of basal forebrain and pontine cholinergic mechanisms within the brain.They found that (1) the cholinergic system contributes greatly to visual attentional function,but not to mnemonic processes per se;(2) the septohippocampal projection influences the modulation of short-term spatial (working) memory processes；and (3) the diagonal band-cingulate cortex cholinergic projection influences the ability to utilize response rules.This suggests that cognitive processes are highly complex,and that Al research should explore brain functions in depth.

Furthermore,Frank and Claus (2OO6) explored how different parts and systems within the brain inform decision making processes. Recent work in this cluster developed connections between the scholarly understanding of those cognitive processes and the advances in Al that emulate some of them.Despite this progress in technology, there are challenges Al still faces.For example, Lake et al. (2017) highlighted that even though Al is able to solve problems through pattern recognition,there is still significant progress needed before these systems are able to explain and understand phenomena, and to build knowledge gained via intuitive theories.

# 4.3.3丨 Neural networks

Cluster 3 focuses on the formation of neural networks,their role within psychological functions,and the formation of human personality.Neural networks are defined asa number of brain areas that, when used together,can carry out a psychological and/or physiological functions (Posner & Rothbart, 2OO7).For instance,they can help humans identify faces by connecting different parts of the brain (O'Toole et al.,2OO2).Neural networks are also important to the formation of human personality and are closely related to temperament,which is conceptualized as the initial stage from which personality develops (Rothbart,2OO7).For example,neural networks help scientists understand specific cognitive processes that are important to perform certain tasks.For instance,Posner and Rothbart (2007) examination of neural networks focused on how attention works.They argue that neural networks,genes,and socialization can explain human behavior and emotions.

# 4.3.4丨Machine learning and linguistic analysis

Cluster 4 connects the field of psychology with advancements in computer science，namely through the use of machine learning. Machine learning is understood “as a computational strategy that automatically determines (i.e., learns) methods and parameters to reach an optimal solution to a problem rather than being programmed bya human a priori to deliver a fixed solution"(Dwyer et al.,2018, p.94).Part of the discussion found in this cluster relates less with how machine learning can help understand cognitive processes,but it is more centered on reshaping the field of psychology by incorporating principles from computer science.For instance,Yarkoni and Westfall(2O17) criticize the field of psychology for their focus on explaining the causes of behavior,but not developing theories around predicting future behaviors accurately.They argue that the field of machine learning might help overcome this limitation,and refocus the attention from explanation to prediction.

Otherarticles in this cluster focus more specifically on the field of psychology and linguistics and contribute to the understanding of speech and cognitive styles,and how different application of machine learning can leverage this knowledge to better understand behavior. Central to this area of knowledge is the work of Pennebaker et al. (2003) which emphasizes the importance of particles (e.g., pronouns, articles,conjunctions,prepositions,and auxiliary verbs) in speech, suggesting that they serve as markers of emotional states,social identity,and cognitive styles.They also examine some of the technologies available to process natural language through computers.

# 4.3.5丨 Social media and text mining

Cluster 5 emphasizes how user-generated content on social media can be used to inform marketing decisions.Social media emerged as an environment where consumers engage in a many-to-many communications and the creation and dissemination of content,which were all further fostered by the emergence of online communities (Kaplan & Haenlein,2O1O). Brands saw an opportunity to be where their target audiences where and started to permeate their presence in this environment (Fournier& Avery,2O11;Wirtz etal.,2013).

However,marketers were faced with the challenge of how to systematically analyze and act on the large amount of unstructured data that were creating in blog posts,online reviews,and social networking sites (Wedel & Kannan,2O16).This cluster covers the literature that explored the use text mining techniques-by several scholars considered as Al techniques-in the context of social media. For instance,Netzer et al.(2O12) outlined an early form of text mining apparatus to analyze data from forums,mainly to identify patterns through the identification of terms that co-occur in text.The work of Goh et al.(2O13) was another example of efforts to connect social media activity with firm outcomes.Through the use of text mining techniques on social media user-generated content they were able to build an econometric model that measures the impact of social media activity on purchase behavior.Ina similar vein,Archak et al.(2O11) used text mining techniques to examine user-generated content related to product (e.g.,online reviews) that moved beyond valence and volume analysis and showed how sentiment towards specific product features predicts future sales.

# 4.3.6丨 Social media content analytics

Closely related to the previous cluster,cluster 6also focuses on social media as a context.However,rather than focusing on the technical aspect of the extraction of social media data,this cluster advances our understanding of implementing analytics programs on social media data to inform business decisions (Andzulis et al.,2O12, Choi et al.,2O18) and derive additional consumer insights in different industry contexts.For instance,Xiang et al (2O15) examined the relationships that existed between guests'experiences shared in online reviews and the satisfaction ratings given by those guests,and they found a strong correlation between both aspects.In particular,guest experience elements related to maintenance aspects (e.g., how clean the room was) and experiential elements (e.g., location,views) had a strong impact on customer satisfaction.Xiang et al (2O17) further extended their work on text analytics applied to the hospitality industry by comparing the data structure and quality of popular online review platforms,and finding differences in their linguistic characteristics,semantic features,sentiment,rating,usefulness as well as the relationships between these features.Kwok and Yu (2O13) used text analytics techniques to identify the type of content (e.g., text, link,photo,and video) and message (e.g.，marketing vs.conversational) that received more engagement on Facebook in the context of restaurants.

Making connections between social media analytics as part of a big data analytics (BDA) program,Xu et al.(2O16) introduce a framework that combines insights from big data (e.g., social media) and traditional marketing sources to the development of new products. They also provide a taxonomy to determine the instances in which more reliance on big data versus traditional marketing data sources is moreappropriate.

Finally,Fan et al. (2O15) provide insights on when using and analyzing social media content is better than marketing's more traditional approaches such as surveys or advertising to derive customer insights.For example,the authors suggest that social media content analysis can help with customer segmentation and customer profiling, online reviews can help build a product's brand reputation,and social media can support location-based advertising,amongst others.They argue that using BDA tools enabled by Al-enabled algorithms can increase the predictive capabilities of those tools.

# 4.3.7丨 Technology acceptance and adoption

Cluster 7 explores the drivers of acceptance and adoption of different forms of technology.One of the prominent contexts relates to wearable technologies whereby the drivers of smartwatches acceptance were studied using the technology acceptance model (TAM; Chuah et al.,2O16) together with various potential moderators (e.g., visibility and consumer familiarity with smartwatches (Davis,1985). In a healthcare context,Wang et al (2O15) developed an integrated acceptance model of wearable technology based on unified theory of acceptance and use of technology 2(UTAUT2),protection motivation theory (PMT),and privacy calculus theory (PCT).

Similar to the context of wearable technologies,well established frameworks like theTAM were used to determine the adoption of loT with existing users in China of an electronic toll collection system (Gao & Bai, 2O14). Other contexts examined in this cluster include internet banking (Alsajjan & Dennis,2O1O),mobile learning (Tan et al., 2014),and mobile commerce (Liebana-Cabanillas et al.,2017).

# 4.3.8丨 Big data and robots

Cluster 8 examines the role of big data,different forms of automation including robots,and their relationship with marketing management and the consumer.From a big data perspective, Erevelles etal.(2016) use the resource-based theory (RBT) to explain big data's impact on marketing management.Specifically, they provide examples of how adaptive and dynamic big data capabilities can lead to value creation through all elements of the marketing mix.Within this cluster the theme of automation and robots is also prominent.Lee and See (2004) highlight the importance that user's trust in automation and new technology in their reliance on the technology.

Furthermore, the literature on robots explores the role that this technology will have in different settings,such as services (Borghi & Mariani,2021; Mariani& Borghi,2021;Wirtz et al.,2018)and service encounters (Paluch & Wirtz,2O2O;Pitardi et al.,2021).Robots integrate several cognitive processes replicated by machines and rely onmultiple sensors to autonomously perform complex actions.Prominent work in this area discusses at a conceptual level how robots can operate in service settings (Van Doorn et al.,2O17;Wirtz et al., 2018; Huang & Rust, 2018).

Additional studies focus on human-robot interaction and drivers of acceptance of social robots based on different occupational roles (e.g.,security services and healthcare),gender (male vs.female),and personality (extrovert vs.introvert; Tay et al.,2O14),and even the formation of attitudes towards service robots among children (Kahn et al., 2012).

# 4.4丨Theoretical lenses

To identify the different theoretical lenses used to inform the studies in our SLR,the abstracts were analyzed searching for the keywords “theory”and“model" to identify the theories and models that the articles contributed to.In total,538 articles mentioned a theory or model in the abstract.From those papers,412 different theories and models were identified,and Table 2 provides a summary of the 16 most frequently used theories organized by frequency on mention.

# 4.4.1丨 Technology acceptance model

The TAM is one of the most widely applied model of users' acceptance and usage of technology (Venkatesh,2OOO).TAM holds that perceived ease of use and perceived usefulness are critical factors in predicting users'acceptance of a technology.Hong et al.(2O17) used the TAM framework in conjunction with other adoption theories,including the diffusion of innovation model,expectation-confirmatory theory，and flow theory to explore the factors that determine consumer intentions to use or purchase a smartwatch.Pitardi et al.(2O21) predict the intention to use voice-based assistants using TAM in combination with enjoyment, social presence, social cognition,and privacy.TAM was also used by Park etal.(2O21) to investigate the adoption of service robots in credence and experience service settings.

# 4.4.2丨 Unified theory of acceptance and use of technology

UTAUT identified four key factors (i.e.，performance expectancy, effort expectancy,social influence,and facilitating conditions) and four moderators (i.e.,age,gender,experience,and voluntariness) related to predicting behavioral intentions and use of a technology (Venkatesh et al.,2O16). Prominent exemplar papers have used UTAUT in conjunction with other theories.For example, the work of Gao et al.(2O15) integrated an updated version of UTAUT with PMT and PCT to investigate the factors associated with consumer's intention to adopt wearable technology in healthcare.The latter two theoretical lenses were included because they are relevant in the context of health behaviors and the use of health technology. First,PMT posits that coping appraisal (i.e.,response efficacy,response cost,and self-efficacy) and threat appraisal (i.e.,perceived vulnerability and perceived severity) influence decision making. Second,PCT argues that when user's perception of benefit exceeds the privacy risk loss consumers would choose to adopt the behavior.

Another example on how UTAUT has been expanded is the work of Moriuchi (2O21) that integrated the four core factors of UTAUT in conjunction with realism maximization theory and literature on anthropomorphism to determine virtual assistant's usage experience and intention to re-use this technology. Madigan et al.(2O17) used UTAUT to test the factors that influence users'acceptance of automated road transport systems (ARTS),where they found hedonic motivation to be the strongest predictor of behavioral intentions to use ARTS.

TABLE 2Prominent theoretical lenses in Al research related to marketing, consumer behavior,and psychology   

<html><body><table><tr><td>Theories</td><td></td><td> Sample articles</td></tr><tr><td>1</td><td>Technology acceptance model</td><td>Hong et al. (2017); Park et al. (2021)</td></tr><tr><td>2</td><td>Unified theory of acceptance and use of technology</td><td>Gao et al. (2015); Madigan et al. (2017)</td></tr><tr><td>3</td><td>Game theory</td><td>Wu et al. (2016); Mathur and Reichling (2016)</td></tr><tr><td></td><td>4Theory of mind</td><td>Osbeck (2009); Steele (2002)</td></tr><tr><td>5</td><td>Theory of planned behavior</td><td>Kowatsch and Maass (201O); Perrie et al. (2020)</td></tr><tr><td>6</td><td> Computational theories</td><td>Thagard (1989); Butz (2016)</td></tr><tr><td>7</td><td>Behavioral reasoning theory</td><td>Sivathanu (2018); Pillai and Sivathanu (2020)</td></tr><tr><td>8</td><td>Decision theories</td><td>Frantz (2003); Lawler and Elliot (1996)</td></tr><tr><td>9</td><td>Evolutionary theory</td><td>Schlesinger (2004); Swenson (1997)</td></tr><tr><td></td><td>10Flow theory</td><td>Shirzad and Van der Loos (2016); Poushneh (2021)</td></tr><tr><td></td><td>11Fuzzy theories (i.e.,fuzzy trace theory,fuzzyReyna and Casillas (2Oo9); Deng (2008) set theory)</td><td></td></tr><tr><td></td><td>12Graph theory</td><td>Heeren et al. (2019); Lai et al. (2019)</td></tr><tr><td></td><td>13Institutional theory</td><td>Teng et al. (2020); Zollet (2014)</td></tr><tr><td></td><td> 14Adaptive resonance theory</td><td>Protopapas (1999); Raijmakers and Molenaar (2004)</td></tr><tr><td></td><td>15Cognitive dissonance theory</td><td>Shultz and Lepper (1996); Jun et al.(2014)</td></tr><tr><td></td><td>16Consumer culture theory</td><td>Belk and Sobh (2O19); Hollebeek and Belk (2021)</td></tr></table></body></html>

density,and firms'BDA investment strategy.Their findings show a positive correlation between investment in BDA and higher profits.

# 4.4.3| Game theory

Game theory aims to understand situations in which decision markers interact (Osborne,2Oo4). Prominent exemplar papers that used game theory are the works of West and Lebiere (2OO1) who,informed by game theory and using neural networks to represent individual players,were able to developa model that accurately describes human behavior in the context of playing games.A notable study enabled by this theory is the work of Mathur and Reichling (2O16) that examined human-robot interactions in an investment game.They found that while classic elements of human social psychology govern human-robot social interaction,robust uncanny valley effects as android faces become more human than mechanical, they began to be perceived as unlikable until the point where faces became nearly human,in which case likability increased.

Another notable paper is the work of Wu et al. (2O16)who employed game theory to investigate the dynamics of wearable device market and considering aspects of consumer diversity,consumer

# 4.4.4| Theory of mind

The theory of mind maps physiological and mental phenomena,and has been central to Al research as it posits that mind can be realized ina wide range of set materials,both organic and inorganic (Steele, 2002).The theory of mind has two components: first order recursive thinking which implies the meta-representation or the representation of a mental representation of a low complexity level;and second ordermeta-representations of a greater complexity (Di Dio et al., 2020).A prominent study in this field is the work by Osbeck (2009) that examined the differences between models of cognition and information processing models. Models of cognition are found in psychology and are underpinned by the tenet that the mind is a complex system of representations of the world.On the other hand,information processing models found in computational sciences suggest that the mind acts more like a computer，processing units of information. Information processing models underpin the development of Al.

# 4.4.5丨 Theory of planned behavior

The theory of planned behavior is a psychological theory that links beliefs with intentions and ultimately behavior itself. The theory posits that attitudes towards the behavior,subjective norm,and perceived behavioral control determine the intentions to perform a specific behavior,and that intention is a strong predictor of actual behavior (Ajzen,1991).The theory has been applied extensively in several consumer research settings,and from the studies captured by our literature review notable work is that of Kowatsch and Maass (2010) that integrated this theory together with the TAM (Davis, 1989)to determine the intention to use mobile recommendation agents (MRAs),the intention to prefer stores that used this technology,and the purchase intentions to buy the products after using MRAs.Another example of application of this theory is the work of Perri et al.(2O2O) that utilize it to study the intention of consumers to adopt the smart grid technology. Their study included the three antecedents of intentions described by Ajzen (1991) with an additional variable related to resistance to change.In both studies the theory helped explained the behavioral intentions being measured.

# 4.4.6丨 Computational theories

Computational theories posit that the mind works like a computer. The most notable work in this area is the work of Thagard (1989) that developed the computational theory of explanatory coherence to apply to the rejection and acceptance of hypotheses as well as to explain reasoning of everyday life.The theory consists of seven principles that capture properties such as if some set of properties P explain some other property Q,then all properties in P must be coherent with Q; that is,people will be more likely to accept explanations if they are consistent with their prior beliefs (Miller,2O19).Thagard's work has helped with the advancement in explainable Al,an area of research that aims to develop explanations of Al behavior beyond mere intuition of the researcher (Miller,2019).

Another prominent computation theory is the computational theory of cognition.This theory is a unifying theory that combines psychological theories (e.g.,theory of event coding,event segmentation theory，the theory of anticipatory behavioral control,and concept development),Al and machine learning theories (e.g.,reinforcement learning and generative artificial neural networks),and theories from theoretical and computational neuroscience (e.g., predictive coding and free energy-based inference) (Butz,2O16).The theory suggests that thought (including thoughts about possibly hypothetical,highly abstracted,imagined scenarios,and behavior in such scenarios) is generated by sets of currently active encodings.

# 4.4.7丨Behavioral reasoning theory (BRT)

BRT is another behavioral intention theory that develops from the theory of planned behavior. The theory integrates adoption and resistance factors in one single model,notably by the including reasons for and reasonsagainsta specific behavioras antecedents of the beliefs included in theTheory of Planned Behavior (Westaby,2OO5).Prominent examples of applications of this theory are the work of Sivathanu (2O18) to understand the use of loT based wearables in the context of healthcare, and later the work of Pillai and Sivathanu (2O2O) that applied the theory to the adoption of loT produces in the agriculture industry where vast amounts of data flows and storage can be managed through the use of Al.The theory has also been used to understand attitudes and intentions towards adopting autonomous vehicles (Huang& Qian,2021).

# 4.4.8丨 Decision theories

Decision theories are rooted in the belief that the human mind and decision making do not need to be mysterious processes and instead they can be mapped (Frantz,2OO3). In the field of Al,decision theories have informed programming of algorithms in expert systems in the context of human resource management around heuristics decision making (Lawler& Elliot,1996).Furthermore,Matsui (2OOO) established that case-based decision theory (CBDT) can lead to equivalent results than more traditional expected utility theories that analyze human behavior under uncertainty in economics and game theory.In the case of CBDT,decisions under uncertainty are made by analogies to previously encountered problems (Gilboa & Schmeidler,1995).

# 4.4.9丨 Evolutionary theory

Evolutionary theory,usually associated with Darwin,suggests that evolution occurs due to natural selection. Academics inPiattelli this area discuss for and against evolutionary perspectives to cognitive processes such as learning.For instance，the work of PiattelliPalmarini (1989) examines evolutionary perspectives of learning and argues against the adaptationist view of the process,and instead suggests that learning results from exaptation.

On the other hand, Darwinian evolutionary theory has also been heavily criticized.In particular the work of Swenson (1997) deconstructs the arguments posited by Dennett (1995) that used evolutionary theory to explain psychological and epistemic dimensions of the world. Evolutionary theory has enabled the emergence of evolutionary computation (EC) that draws on neo-Darwinian principles (e.g., natural selection, mutation).A subfield of EC is that of evolutionary robotics,which unlike traditional Al methods (e.g.,expert systems) depart froma naive robot that learns by exploring and interacting with its environment by trial and error by building their own knowledge rather than relying on large datasets to learn particular outcomes.

# 4.4.10丨 Theory of flow

The theory of flow explains the mechanics of engagement with a task (Csikszentmihalyi,1991). Flow is defined as the satisfying feeling of heightened functioning in a task with full concentration to finish it (Csikszentmihalyi& Csikzentmihaly,199O).The theory has been used to develop robots that adapt the level of difficulty of tasks to increase engagement and improve user experience (Shirzad & Van der Loos, 2016).

Poushneh (2O21) extended flow theory by examining the effect that voice assistant personality traits drive the voice interaction flow experience that can influence consumers'attitudes and behavioral intentions.Furthermore，Balakrishnan and Dwivedi (2O21） found that human-to-machine interaction influences cognitive absorption (a state of flow) more positively than human-to-human interaction.

# 4.4.11丨 Fuzzy theories

Fuzzy theories focus on explaining different cognitive processes. An example is fuzzy trace theory that introduce dual-trace conceptions, composed of exact literal memory (i.e.，verbatim traces) and fuzzy representations of past events (i.e.,gist traces).Both traces predict and explain cognitive phenomena,particularly in memory and reasoning.Using fuzzy trace theory,Reyna & Casillas,(2Oo9) develop theoretical propositions to reduce low numeracy in the context of medical decision making.Unlike original set theories,where an item is eithera member or not of a set,fuzzy set theories recognize that some sets have less clear boundaries (Maiers & Sherif,1985).Applications of this theory are found in the fields of Al,computer science,medicine,control engineering,decision theory,expert systems, pattern recognition,and robotics (Zimmermann 2O1O). From our review, notable studies applying fuzzy set theory is the work of Deng (2008) to improve conventional importance-performance analysis which was used by managers in determining critical service attributes to improve service quality and customer satisfaction.

# 4.4.12丨 Graph theory

Graph theory is concerned with the study of graphs.The majority of studies on graph theory dates to the 194Os and 1950s when work on social networks allowed to discover emergent groups and trends in network data (Bondy & Murty,1976).Graph theory precedes more recent work on network analysis (Heeren et al.,2O19).Some prominent papers in the field include the work of Lai et al (2O19) who used graph theory to analyze user generated content collected via text mining to inform design generation,product improvement,and market analysis.

# 4.4.13丨 Institutional theory

The institutional theory is traditionally concerned with what and how organizations act upon to secure their positions and legitimacy by conforming to social norms,rules,and beliefs (DiMaggio & Powell, 1983).The theory has been applied in studies that examine environmental management in organizations (Glover et al., 2014; Hoffman，1999)，social values changes (Ball & Craig，201O)，and technologyadvancementsrelatedtosustainableactivities (Lounsbury,1997). More recently,Teng et al. (202O) used the theory in combination with text mining and sentiment analysis techniques to categorize themes of the public opinions toward palm oil and its environmental impacts.

# 4.4.14| Adaptive resonance theory (ART)

ART combines neurobiological plausibility with mathematical rigor to explain a range of psychological and neural findings,including memory, learning,attention,priming,and pattern recognition (Protopapas,1999). During the presentation of input vector,ART networks create categories online and are able to classify known and unknown input vectors (Raijmakers& Molenaar,2OO4). Raijmakers and Molenaar (2O04)demonstrated how neural networks,through the use of change in the equilibrium behavior,acquire new knowledge.

# 4.4.15丨 Cognitive dissonance theory

The cognitive dissonance theory posits that dissonance is a psychological state of tension that people are motivated to reduce (Festinger,1957).The theory has been used to explain psychological phenomena such as the transmission of rumors,rationalization of decisions,selectivity in information search and interpretation,and responses to disconfirmation of beliefs (Shultz & Lepper,1996). Shultz and Lepper (1996) contrasted the application of the cognitive dissonance theory with a neural network model and found that the neural network model fit the data better than cognitive dissonance theory has explained in the past.Jun et al. (2O14) compared how search traffic information gathered from Google Insights can provide more accurate representations of consumer attitudes than survey research that tends to be affected by cognitive dissonance.This also allows to avoid consumers presenting themselves in a positive light when responding to surveys.

# 4.4.16丨 Consumer culture theory (CCT)

CCT refers to a family of theoretical perspectives that address the dynamic relationships between consumer actions,the marketplace, and cultural meanings (Arnould & Thompson,2Oo5). Some of the papers that were captured by our literature search posit that that big data,the use of algorithms and market analytics are limiting the ability of consumer researchers to cultivate their own theories (Belk & Sobh,2O19). In another study, Hollebeek and Belk (2O21) compared positivist models such as the TAM and the positive emotions,engagement，relationships，meaning，and accomplishments (PERMA) model that consist with CCT perspectives to examine consumers' technology-facilitated brand engagement and wellbeing.

# 4.5丨 Emerging theories

Based on frequency analysis of the theories that display lower overall frequency in the full sample but recorded the fastest growth over the last year,we identified a number of emerging theories.These theories could help advance knowledge in this area further.These include anthropomorphism,construal level theory(CLT),actor-network theory (ANT),and RBT.

# 4.5.1丨 Anthropomorphism

Anthropomorphism consists in the attribution of human mental states or affects to non-human entities such as animals and objects (Airenti,2O18).The sociality,effectance,and elicited agent knowledge (SEEK) model has been the major social psychological theory to organize our understanding of anthropomorphism (Epley etal.,2007). Sociality relates to the human need to form social connection with other humans,whilst effectance relates to the need to interact effectivelywith one's environment.Finally,elicitation of agent knowledge relates to the knowledge agents gather about humans and their behavior.A combination of the three factors are considered to explain the anthropomorphism of objects.In relation to this psychological phenomena,neurophysiological research has found that humans react more to a nonanthropomorphic robot when a human interacts in a social way with the robot as opposed than when interacting in a functional way (Hoenen et al., 2016).

Notable research in this area examines how,as we move towards building robots that look and behave like humans,emerging concerns about deception,privacy,job loss,safety,and the loss of human relationships become more prevalent (Broadbent,2O17).Of interest is also the work of Araujo (2O18) on disembodied conversational agents (chatbots) and the extent to which human-like cues such as language style and name influence perceptions about social presence as well as mindful and mindless anthropomorphism.

# 4.5.2丨 Construal level theory

CLT introduces the concept of psychological distances to explain how people perceive objects (or persons)at different construal levels, which in turns affects how those objects are being evaluated (Trope & Liberman,2O1O).Construals are conceptualized as the individuals' perception and action in seeking to comprehend,categorize,identify and/or recognize what they encounter (e.g.,a task or an experience). The theory posits that when psychological distances increases, construals become more abstract,and as the level of abstraction increases so too would the psychological distances people envisage.

Changes in distances perceptions also influence prediction,evaluation,and action (Adler & Sarstedt,2O21).The theory has advanced several aspects of consumer research on perception，information processing，preference shifts,and decision making. In terms of Al, the theory has informed research on natural language processing.

For example, the work of Bhatia and Walasek (2O16) found that text posted on social media mentioning temporally proximate dates used more concrete words than those mentioning distant dates.

# 4.5.3丨 Actor-network theory

ANT explains human behaviors (e.g,consumption behaviors)and people's interactions with inanimate objects.According to ANT,an actor is conceptualized as the source of an action regardless of its status as a human or non-human. Cresswell et al. (2O1O) argue that this is a radical notion in that it contests that inanimate things (e.g., such as technology) can also have agency.The theory has enabled research on the implementation of new technology in different settings.For instance,Bruni (2OO5) used ANT to explore the use of electronic clinical records in a healthcare settingand the role of infrastructures and virtual environments on patient usage of technologies.Furthermore，Van Oost and Reed (2O1O) used an actornetwork approach to identify the social and ethical dimensions of the increased use of robots as companions.

# 4.5.4丨 Resource-based theory

RBT provides a theoretical lens when examining the implications of Al in marketingat a meso-level from an organizational perspective.RBT suggests that a firm's resources,both tangible and intangible, facilitate its performance and competitive advantage when the resource is valuable,rare,imperfectly imitable,and exploitable by the organization (Barney,1991).A resource is valuable when it generates value to the firm or the customer.Rare resources are those that are not abundant.Imperfectly imitable resources are difficulty for competitors to copy,and finally,an exploitable resource that one that the firm can benefit from in a way others cannot. Here,RBT has been used to examine the potential impact that new resources that enable many of the Al applications in marketing (e.g.,big data) can become a source of competitive advantage (Erevelles etal.,2016).

# 5丨 CONTRIBUTION AND CONCLUSIONS

This study makes several key contributions to research in Al.First, we focus on Al in the interrelated fields of marketing,consumer research, and psychology.This represents a way to capture in a more holistic manner research on Al in disciplinary areas whose boundaries are often blurring when dealing with Al.This represents an advancement over recent bibliometric studies and literature reviews that have more narrowly focused on Al in marketing，without taking into account the cognate field of psychology (Mustak etal.,2021; Vlacic etal.,2021).

Our SLR shows that the publications in the interrelated areas of marketing，consumer research,and psychology has recorded exponential growth over the last decade,with the most publications being in journals that focus on psychology and human-computer interactions, followed by computer and information system journals, and business research，marketing，and sector specific journals. Clearly,cross-fertilization between these fields should advance our understanding of Al as each field explores similar issues from their discipline's particular lens.

Second, in addition to adopting bibliometric techniques,we focused on the overarching intellectual structure emerging from the three steams of literature and therefore move beyond traditional disciplinary boundaries and look at the multidisciplinary linkages and dialogue between these three fields.As such,this SLR study is by definition multidisciplinary and identifies topical areas in a holistic process.This means, for instance, that marketing phenomena are captured also in relation to their psychological drivers which is in line with the philosophy,aim and scope of Psychology& Marketing (Donthu etal.,2021).

In particular,we compellingly connect and synthetize theory found in the literature (Vargo & Koskela-Huotari,2O2O) by identifying eight major clusters where research in the focal areas have developed. Through our analysis of keywords occurrence,we were able to identify the keyword co-occurrence networks in this field (which we named using the term occurring more frequently within the network): big data, machine learning,Al,data mining,neural networks,marketing,and ecommerce.Furthermore,using bibliographic coupling,we identify topical areas and illustrate the relationships that exist between the topical areas in the literature.

Using bibliographic coupling eight clusters of research were identified which range from those that are heavily reliant on computer science (memory and computational logic，neural network，machine learning and linguistic analytics),psychological sciences (decision making and cognitive processes),and themes related to technology acceptance/ adoption and applications to marketing and consumer research (technology acceptance and adoption,big data and robots, social media and text mining and social media content analysis).

Third,and as a corollary of the previous point,we identify and discuss the wide range of theoretical lenses and models adopted to get to a better understanding of Al.This attention to theoretical lenses and models can help not only to connect studies formally belonging to the different literatures,butalso to cross-fertilize the use of theories across fields.Specifically,we identified a total of 412 different theories and models,with the most frequently used being: Game theory,theory of mind,theory of planned behavior,computational theories,BRT,decision theories,evolutionary theory,flow theory,fuzzy theories,graph theory, institutional theory,ART,cognitive dissonance theory,CCT,and UTAUT (including its predecessor,the TAM).

Finally,we identified a number of emerging theories in the literature that could help to advance knowledge in Al. They are anthropomorphism, CLT,ANT,and RBT.

# 6I FUTURE RESEARCH AVENUES

As comprehensive,structured,and analytical means of accurately organizing research articles,a SLR is an effective method to identify gaps in the literature (Klassen et al.,1998;Paul & Criado,2O2O) and highlight areas that remain understudied but should receive further attention (Snyder,2O19).We first discuss findings that flow directly from our literature analysis,followed by topics the author team sees as important but that have not yet been covered much in the literature.

# 6.1丨 Reconfiguring the clusters of bibliometric coupling

This SLR identified the following eight clusters:(1) memory and computational logic,(2) neural networks,(3) machine learning and linguistic analytics,(4) decision making and cognitive processes,(5) technology acceptance and adoption,(6) big data and robots,(7) social media and text mining,and (8) social media content analysis. These clusters could be linked to each other and thus reconfigured into three macro-clusters (as clarified in Section 4.3) due to the proximity of the topical areas of the clusters.The first macro-cluster includes articles that are heavily reliant on computer science (memory and computational logic,neural network,machine learning and linguistic analytics).We predict that several research opportunities can arise and contribute to the expansion of this macro-cluster in the future as cross-disciplinary studies involving computer science,brain science and social sciences might become increasingly relevant. In this area,research on explainable Al will help overcome some of the emerging challenges around the use Al in daily settings,particularly in terms of improving transparency and trust, enabling auditing of Al systems for regulatory reasons,and to enable adjusting of Al systems when they behave unexpectedly.The second macro-cluster includes articles that relate mostly to psychological sciences (decision making and cognitive processes).This is an area that has already witnessed some growth but could record further evolution as an increasing number of Al scholars from outside the psychology field team up with psychology experts to understand the psychological underpinnings of human perceptions of and interaction with Al. The third macrocluster entails studies related to technology acceptance/adoption and applications to marketing and consumer research (technology acceptance and adoption,big data and robots,social media and text mining and social media content analysis).While this is a relatively mature area,further research is likely to cover Al technologyacceptance and adoption as Al technologies evolve further.

# 6.2丨 Cross-fertilization of theories used across fields

The different clusters can cross-fertilize each other not only in terms of commonalities of topics,but also in terms of theories.For example, decision theories can be adopted in conjunction with game theories to generate added value in studies that will focus on data-driven models.For example,evidence suggest that some marketing activities could be outperformed by automated systems relying on machine learning (Salminen et al.,2O19). Here,decision theories and game theories might help build stronger frameworks whereby theoretically driven explanatory models based on game-theoretical decision making can be combined with data-driven predictive models of consumer behavior.This will extend work that has been carried out in the following clusters:social media and text mining;big data and robots.

BRT could be integrated by scholars into several different clusters and blended with TAMs and theories.Indeed,it might be increasingly leveraged in acceptance and adoption studies to contextualize the reasons for/against adopting a technology depending on the type of technology and the context specific to that technology.For instance,the reasons for/against adopting Al technology are significantly different in healthcare versus consumer goods contexts and blending BRT with technology acceptance might shed light on factors positively or negatively influencing the adoption behaviors of Al technology across distinctively different settings. Furthermore,some technologies that rely more on the disclosure of personal data to allow customization might lead to higher levels of privacy concerns as a barrier of adoption (Lobschat et al., 2021).

CCT might generate opportunities to advance our understanding of how the growing use of Al technologies and social media platforms influence cultural production (e.g.,Rokka,2O21) and the way consumers make sense of cultural production.For instance,Al-powered algorithms used by music streaming platforms that allow to match past preferences with music and songs' libraries,could constrain the way consumers can discover new music genres or soundtracks.This in turn might prevent consumers from designing their own cultural choices due to increasingly standardized and backward-looking cultural categories (e.g.,established music genres).In general, CCT might help explain to what extent data analytics and the use of algorithms are somehow making consumers less proactive in identifying their own cultural tastes and more prone to passively accept what algorithms recommend.

# 6.3丨Neglected research topics

We were surprised that important topics did not seem to get the research attention we feel they should deserve.First,Al-related ethics,fairness and privacy are probably the most important topics that have not had the prominence they deserve in our three fields of study.In addition to concerns related to privacy,the unprecedented power of Al (Bornet et al.,2O21；Brynjolfsson & McAfee,2017) poises important ethical dilemmas (Belk,2O2O; Breidbach & Maglio, 2020;Rahwan et al., 2O19). These include how customer data are used in Al systems for automated decision making (e.g.,whether and at what interest rate to approve a housing loan) which can result in biased and unfair consumer outcomes (e.g.,a loan rejection and overpricing).At a higher level,Al can cause concern related to loss of autonomy,dignity,social isolation,dehumanization,and more (Belk, 2020; Caic et al., 2018; Vandemeulebroucke et al. 2018).

Recent work on corporate digital responsibility (CDR) integrated these topics,whereby CDR relates to the ethical responsibilities organizations (including marketing departments) need to face when creating and operating Al and other digital technologies and the data they produce (Wirtz et al.,2O21).CDR seems especially important when digital platform business models are involved as they largely operate via scalable and autonomous Al and provide complete visibility of all actors and their behaviors on the a platform (Rangaswamy et al.,2O2O).Lobschat etal.defined CDR as a “set of shared values and norms guiding an organization's operations with respect to the creation and operation of digital technology and data"(p.876).Organizations (and their marketing and service departments) need to ensure that customers are treated ethically,fairly and that their privacy rights are protected.We need more research to better understand how to do this and what the customer implications of good (and bad) CDR are.

Second,it is easy to see the downsides of Al and the literature has examined many potential consumer concerns related to Al and why consumers may not want to use it (e.g., Lu et al.,2O2O). However,there are also advantages consumers value.For instance,consumers have been shown to prefer Al- over people-delivered service in potentially embarrassing situations (Pitardi etal.,2O21).As would be predicted by theory of mind and agency,Al's inability to make social judgments may be an advantage in other contexts,such as in situations where consumers can feel unpleasant emotions such as shame,shyness,and guilt.We feel that more work is needed to better understand consumer benefits of Al.

Finally,there is significant Al literature in (service) operations management that has focused on productivity gains, service improvements (e.g.,enhanced convenience,availability,better affordability， and frictionlesscustomerjourneys)，and end-to-end automation of customer service processes (e.g.,Wirtz & Zeithaml, 2018). Likewise,the computer science literature has a long tradition of Al research (e.g.， Jordan & Mitchell,2O15),and it would be of interest to examine the applicability of the theories used in these field in marketing contexts.

# 7—LIMITATIONS

A limitation of our study were the decisions we made for data extraction where we opted for Scopus over WoS and Google Scholar. While this is consistent with recent work (Gusenbauer & Haddaway, 2020; Ling et al.,2O21), future research might also collect data from different databases. However,retrieving data from WoS would yield only a subsample of the scientific articles obtained as we found when running the same queries in WoS,and extracting data from Google Scholar would increase significantly the complexity of retrieving meaningful metadata for large-scale bibliometric studies (MartinMartin et al.,2O18). Overall,using a major database like Scopus is consistent with previous research but casting the net wider might yield additional insights.

# ACKNOWLEGMENTS

Open access funding provided by Universita degli Studi di Bologna within the CRUl-CARE Agreement.

# CONFLICT OF INTERESTS

The authors declare that there are no conflict of interests.

# ORCID

Marcello M. Mariani $\textcircled{1}$ https://orcid.0rg/0000-0002-7916-2576 Rodrigo Perez-Vega $\textcircled{1}$ https://orcid.0rg/0000-0003-1619-317X Jochen Wirtz $\textcircled{1}$ https://orcid.0rg/0000-0002-6297-4498

#

REFERENCESDe Winter   
Adler,S.,& Sarstedt,M. (2021).Mapping the jungle:A bibliometric analysis of research into construal level theory.Psychology & Marketing,121,800. https://doi.org/10.1002/mar.21537   
Airenti, G.(2018).The development of anthropomorphism in interaction: Intersubjectivity，imagination，and theory of mind.Frontiersin Psychology,9(11), 1-13.   
Alderson,W.(1952).Psychology for marketing and economics.Journal of Marketing,17(2),119-135.   
Alsajjan,B.，& Dennis,C.(201O). Internet banking acceptance model: Cross-market examination.Journal of Business Research,63(9-10), 957-963.   
American Marketing Association (2017). What is marketing? https://www. ama.org/the-definition-of-marketing-what-is-marketing/   
Andzulis,J.M.,Panagopoulos,N.G.,& Rapp,A. (2012).A review of social mediaand implications for the sales process.Journal of Personal Selling& Sales Management,32(3),305-316.   
Apriliyanti,I.D.，& Alon,I. (2017).Bibliometric analysis of absorptive capacity.International Business Review,26(5),896-907.   
Araujo，T. (2O18).Living up to the chatbot hype:The influence of anthropomorphic design cues and communicative agency framing on conversational agent and company perceptions.Computers in Human Behavior,85(8),183-189.   
Archak,N., Ghose,A.,& Ipeirotis,P.G.(2011). Deriving the pricing power of product features by mining consumer reviews. Management Science,57(8),1485-1509.   
Archambault，E.，Campbell，D.，Gingras，Y.，& Lariviere，V.(2009). Comparing bibliometric statistics obtained from the Web of Science and Scopus.Journal of the American Society for Information Science and Technology,60(7),1320-1326.   
Arnould,E.J.,& Thompson, C.J. (2Oo5). Consumer culture theory (CCT): Twenty years of research.Journal of Consumer Research，31(4), 868-882.   
Ajzen,I.(1991).The theory of planned behavior. Organizational Behavior and Human Decision Processes,50,179-211.   
Balakrishnan,J.,& Dwivedi, Y. K.(2021). Role of cognitive absorption in building user trust and experience.Psychology & Marketing，38(4), 643-668.   
Ball,A.,& Craig,R. (2O1O). Using neo-institutionalism to advance social and environmental accounting. Critical Perspectives on Accountig, 21(4), 283-293.   
Barney,J. (1991). Firm resources and sustained competitive advantage. Journalof Management,17(1),99-120.   
Belanche,D., Casaló,L.V.,& Flavian,C.(2O2O).Frontline robots in tourism and hospitality: Service enhancement or cost reduction? Electronic Markets,31,477-492.   
Belk,R.(2O2O).Ethical issues in service robotics and artificial intelligence. The Service Industries Journal,40(3-4),203-235.   
Belk，R.，& Sobh, R. (2019). No assemblage required: On pursuing original consumer culture theory.Marketing Theory，19(4), 489-507.   
Berry,M.J.,& Linof,G.S. (2O04).Data mining techniques: For marketing, sales,and customer relationship management.John Wiley & Sons.   
Bhatia,S.,& Walasek,L.(2O16). Event construal and temporal distance in natural language.Cognition,152(6),1-8.   
Bishop，C.M.(1995).Neural networks for pattern recognition.Oxford university press.   
Bondy,J.A.,& Murty，U. S.R.(1976).Graph theory with applications. Macmillan.   
Borghi,M.，& Mariani，M.M.(2021). Service robots in online reviews: Online robotic discourse.Annals of Tourism Research,87(C),103036. https://doi.org/10.1016/j.annals.2020.103036   
Bornet,P.,Barkin,I.,&Wirtz,J.(2021). Intellgent automation: Welcome to the world of hyperautomation.World Scientific Books.   
Boyack,K.W.，& Klavans,R. (2O1O).Co-citation analysis,bibliographic coupling,and direct citation: Which citation approach represents the research front most accurately? Journal of the American Society for Information Science and Technology,61(12),2389-2404.   
Breidbach,F.C.,& Maglio,P. (202O). Accountable algorithms? The ethical implications of data-driven business models.Journal of Service Management,31(2),163-185.   
British Psychological Society.(2021).What is psychology? https://www. bps.org.uk/public/what-is-psychology   
Broadbent,E. (2O17).Interactions with robots: The truths we reveal about ourselves.Annual Review of Psychology,68(1),627-652.   
Bruni,A.(2Oo5).Shadowing software and clinical records: On the ethnographyofnon-humansandheterogeneouscontexts. Organization,12(3),357-378.   
Brynjolfsson,E.,& McAfee,A. (2017). What's driving the machine learning explosion? Harvard Business Review,18(3),118.   
Butz,M.V. (2O16).Toward a unified sub-symbolic computational theory of cognition.Frontiers in Psychology,7,925.   
Carlson,M.(2O15).The robotic reporter:Automated journalism and the redefinition of labor,compositional forms,and journalistic authority. Digital Journalism,3(3),416-431.   
Chiang,W.Y.K., Zhang,D.,& Zhou,L. (2OO6).Predicting and explaining patronage behavior toward web and traditional stores using neural networks:A comparative analysis with logistic regression.Decision Support Systems,41(2),514-531.   
Choi,T.M.，Wallace,S.W.,& Wang,Y. (2018). Big data analytics in operations management. Production and Operations Management, 27(10), 1868-1883.   
Chong,A.Y.L., Ch'ng,E.,Liu,M.J.,& Li, B.(2017).Predicting consumer product demands via Big Data: The roles of online promotional marketing and online reviews. International Journal of Production Research,55(17),5142-5156.   
Christofi，M.，Vrontis，D.，& Cadogan，J.(2O21)．Micro-foundational ambidexterity and multinational enterprises: A systematic review and a conceptual framework.International Business Review,30(1),101625.   
Chuah,S.H.W., Rauschnabel, P.A., Krey,N.,Nguyen,B., Ramayah,T.,& Lade,S. (2016).Wearable technologies: The role of usefulness and visibility in smartwatch adoption.Computers in Human Behavior, 65(12),276-284.   
Comerio,N.，& Strozzi, F.(2019).Tourism and its economic impact: A literature review using bibliometric tools.Tourism economics,25(1), 109-131.   
Cortez,P.,Cerdeira,A.,Almeida,F., Matos,T.,& Reis,J. (2009). Modeling wine preferences by data mining from physicochemical properties. Decision Support Systems,47(4),547-553.   
Cresswell, K.M.,Worth,A.,& Sheikh,A. (2010). Actor-network theory and its role in understanding the implementation of information technology developments in healthcare.BMC Medical Informatics and Decision Making,10(1),1-11.   
Cui,G.,Wong，M.L.,& Lui,H.K. (2OO6).Machine learning for direct marketing response models: Bayesian networks with evolutionary programming. Management Science,52(4),597-612.   
Caic,M.,Odekerken-Schröder,G.，& Mahr, D. (2018). Service robots: Value co-creation and co-destruction in elderly care networks. Journal of Service Management,29(2),178-205.   
Csikszentmihalyi, M.(1991).Design and order in everyday life.Design issues,8(1), 26-34.   
Csikszentmihalyi,M.,&CsikzentmihalyM.(1990).Flow:Thepsyhology of optimal experience (Vol.199O). New York: Harper & Row.   
Davenport,T.,Guha,A.,Grewal, D.,& Bressgott,T.(202O). How artificial intelligence will change the future of marketing.Journal of the Academy of Marketing Science,48(1),24-42.   
Davis,F.D. (1985).A technology acceptance model for empirically testing new end-user information systems:Theory and results (Doctoral dissertation). Massachusetts Institute of Technology.   
Davis,F.D.(1989). Perceived usefulness,perceived ease of use,and user acceptance ofinformation technology.MIs Quarterly，13(3), 319-340.   
Deng，W.J. (2Oo8)．Fuzzy importance-performance analysisfor determining critical service attributes.International Journal of Service Industry Management,19(2),252-270.   
Dennett, D.(1995). Darwin's dangerous idea.The Sciences,35,34-40.   
DiMaggio，P.J.，& Powell，W.W.(1983).The iron cage revisited: Institutional isomorphism and collective rationality in organizational fields.American Sociological Review,48(2),147-160.   
Di Dio, C., Manzi,F.,Peretti, G., Cangelosi, A., Harris,P.L., Massaro,D,& Marchetti, A. (2O2O).Shall I trust you? From child-robot interaction to trusting relationships.Frontiers in Psychology,11,469.   
Domingos,P.(2017).The master algorithm: How the quest for the ultimate learning machine will remake ourworld.Penguin.   
Donthu,N., Kumar,S.,Pattnaik,D.,& Lim,W.M. (2021).A bibliometric retrospection of marketing from the lens of psychology: Insights fromPsychology& Marketing.Psychology& Marketing，38(5), 834-865.   
Dremel,C.,Herterich,M.M.,Wulf,J.Vom Brocke,&J.(2020).Actualizing big data analytics affordances:A revelatory case study.Information & Management,57(1),103121.   
Dwyer，D.B.，Falkai，P.，& Koutsouleris，N. (2O18).Machine learning approaches for clinical psychology and psychiatry.Annual Review of Clinical Psychology,14(5),91-118.   
Epley,N., Waytz,A.,& Cacioppo,J.T. (2Oo7). On seeing human: A threefactor theory of anthropomorphism.Psychological Review,114(4), 864-886.   
Erevelles,S.,Fukawa,N.,& Swayne,L. (2O16). Big data consumer analytics and the transformation of marketing.Journal of Business Research, 69(2), 897-904.   
Everitt,B.J.,& Robbins,T.W. (1997).Central cholinergic systems and cognition.Annual Review of Psychology,48(1),649-684.   
Fan,S.,Lau,R.Y.,& Zhao,J.L. (2015). Demystifying big data analytics for business intelligence through the lens of marketing mix.Big Data Research,2(1),28-32.   
Ferreira,F.A.(2O18).Mapping the field of arts-based management: Bibliographic coupling and co-citation analyses.Journal of Business Research,85(4),348-357.   
Festinger,L.(1957).A theory of cognitive dissonance (Vol. 2).Stanford university press.   
Filieri,R.,& Mariani,M. (2O21).The role of cultural values in consumers' evaluation of online review helpfulness:A big data approach. International Marketing Review,38(6),1267-1288.https://doi.org/ 10.1108/IMR-07-2020-0172   
Fournier,S.,& Avery,J.(2O11).The uninvited brand.Business Horizons, 54(3), 193-207.   
Frank,M.J.，& Claus,E.D.(2O06).Anatomy of a decision: Striatoorbitofrontal interactions in reinforcement learning,decision making, and reversal.Psychological Review,113(2),300-326.   
Frantz,R. (2Oo3). Herbert Simon.Artificial inteligence as a framework for understanding intuition.Journal of Economic Psychology，24(2), 265-277.   
Frintrop,S.,Rome,E.,& Christensen,H.I. (2O1O). Computational visual attention systems and their cognitive foundations:A survey.ACM Transactions on Applied Perception (TAP),7(1),1-39.   
Galati,F.,& Bigliardi,B. (2O19).Industry 4.O: Emerging themes and future research avenues using a text mining approach. Computers in Industry,109,100-113.   
Gao,L.,& Bai, X. (2014).A unified perspective on the factors influencing consumer acceptance of internet of things technology.Asia Pacific Journal of Marketing and Logistics,26(2),211-231.   
Gao,Y.,Li, H.,&Luo,Y.(2015).Anempirical studyof wearable technology acceptance in healthcare.Industrial Management & Data Systems, 115(9), 1704-1723.   
Gilboa,I.，& Schmeidler，D.(1995).Case-based decision theory.The Quarterly Journal of Economics,110(3),605-639.   
Ginsberg,A.，& Venkatraman，N. (1985). Contingency perspectives of organizational strategy:A critical review of the empirical research. Academy of Management Review,10(3),421-434.   
Glover,J.L., Champion,D., Daniels, K.J.,& Dainty,A.J. (2014).An Institutional Theory perspective on sustainable practices across the dairy supply chain.International Journal of Production Economics,152,102-111.   
Goh,K.Y., Heng, C.S.,& Lin,Z.(2013).Social media brand community and consumer behavior: Quantifying the relative impact of user-and marketer-generated content. Information Systems Research,24(1), 88-107.   
Grewal,D., Motyka,S.,& Levy,M. (2018).The evolution and future of retailing and retailing education.Journal of Marketing Education, 40(1), 85-93.   
Guo,Y.,Wang,M.,& Li, X. (2017).Application of an improved Apriori algorithmina mobilee-commerce recommendationsystem. Industrial Management& Data Systems,117(2),287-303.   
Gusenbauer，M.，& Haddaway，N.R. (202O).Which academic research systems are suitable for systematic reviews or metaanalyses?EvaluatingretrievalqualitiesofGoogleScholar, PubMed,and 26 other resources. Research Synthesis Methods,11(2), 181-217.   
Hansen,F.(1976). Psychological theories of consumer choice.Journal of Consumer Research,3,117-142.   
Hauser,J.R. (2O14).Consideration-set heuristics.Journal of Business Research,67(8),1688-1699.   
Heeren,A., Hoebeke,Y.,& Coussement, C. (2019). Unfolding the complex dynamic interplay between attentional processes and anxiety:A commentary on Ghassemzadeh,Rothbart,and Posner.Cognitive and Behavioral Neurology,32(1),63-66.   
Hoenen,M., Lübke,K.T.,& Pause, B.M.(2016).Non-anthropomorphic robots as social entities on a neurophysiological level. Computers in Human Behavior,57(4),182-186.   
Hofacker，C.F.，Malthouse,E.C.，& Sultan，F.(2O16).Big data and consumer behavior: Imminent opportunities.Journal of Consumer Marketing,33(2),89-97.   
Hoffman，A.J.(1999).Institutionalevolutionandchange: Environmentalism and the US chemical industry. Academyof Management Journal,42(4),351-371.   
Hollebeek,L.D.，& Belk，R. (2021).Consumers' technology-facilitated brand engagement and welbeing: Positivist TAM/PERMA-vs. Consumer Culture Theory perspectives. International Journal of Research in Marketing,38(2),387-401.   
Hong,J.C.,Lin,P.H.,& Hsieh,P.C. (2017).The effect of consumer innovativeness on perceived value and continuance intention to use smartwatch.Computers in Human Behavior,67(2),264-272.   
Huang,M.H.,& Rust,R.T.(2021).A strategic framework for artificial intelligence in marketing.Journal of the Academy of Marketing Science,49(1),30-50.   
Huang,Y.,& Qian,L. (2O21). Understanding the potential adoption of autonomous vehicles in China: The perspective of behavioral reasoning theory.Psychology & Marketing,38(4),669-690.   
Huang,M.H.,& Rust,R.T.(2O18).Artificial intelligence in service.Journal of Service Research,21(2),155-172.   
Järvinen,J.,& Taiminen, H. (2016). Harnessing marketing automation for B2B content marketing. Industrial Marketing Management,54(4), 164-175.   
Jones,O.,& Gatrell, C.(2014).The future of writing and reviewing for IJMR.International Journal of Management Reviews,16(3),249-264.   
Jordan，M.I.，& Mitchell，T.M.(2015).Machine learning:Trends, perspectives,and prospects.Science,349(6245),255-260.   
Jun,S.P.,Park,D.H.,& Yeom,J. (2O14).The possibility of using search traffic information to explore consumer product atitudes and forecast consumer preference.Technological Forecasting and Social Change,86(7),237-253.   
Kahn PH,Jr., Kanda,T.,Ishiguro,H.,Freier, N.G.,Severson,R.L.,Gi,B.T., Ruckert,J.H.,& Shen,S.(2012)."Robovie,you'llhave to go into the closet now":Children's social and moral relationships witha humanoid robot. Developmental Psychology, 48(2),303-314.   
Kaplan,A.M.,& Haenlein,M. (2O1O). Users of the world,unite! The challenges and opportunities of Social Media.Business Horizons, 53(1), 59-68.   
Kessler，M. M.(1963). Bibliographic coupling between scientific papers. American documentation,14(1),10-25.   
Klassen,T.P., Jadad,A.R.,& Moher,D.(1998).Guides for reading and interpreting systematic reviews:I.Getting started.Archives of Pediatrics & Adolescent Medicine,152(7),700-704.   
Kowatsch,T.，& Maass,W. (201O). In-store consumer behavior:How mobile recommendation agents influence usage intentions,product purchases,and store preferences. Computers in Human Behavior, 26(4), 697-704.   
Kumar,V.,Rajan,B., Venkatesan,R.,& Lecinski,J. (2O19). Understanding therole ofartificial inteligence in personalized engagement marketing.California Management Review,61(4),135-155.   
Kwok,L.,& Yu,B.(2013). Spreading social media messages on Facebook: An analysis of restaurant business-to-consumer communications. Cornell Hospitality Quarterly,54(1),84-94.   
Lai,X.,Zhang,Q.,Chen,Q.，Huang,Y.,Mao,N.，& Liu,J. (2019). The analytics of product-design requirements using dynamic internet data:Application to Chinese smartphone market. International Journal of Production Research,57(18), 5660-5684.   
Lake,B.M.,Ullman,T.D.,Tenenbaum,J.B.,& Gershman,S.J. (2017). Building machines that learn and think like people.Behavioral and Brain Sciences,40,1-72.   
Law,R.,& Au,N.(1999).A neural network model to forecast Japanese demand for travel to Hong Kong.Tourism Management，20(1), 89-97.   
Lawler，J.J.，& Elliot，R.(1996).Artificial intellgence in HRM:An experimental study of an expert system. Journal of Management, 22(1),85-111.   
Lee,J.D.，& See,K.A. (2004).Trust in automation: Designing for appropriate reliance. Human Factors,46(1),50-80.   
Liebana-Cabanillas,F.,Marinkovic,V.,& Kalinic,Z.(2017).A SEM-neural network approach for predicting antecedents of m-commerce acceptance.International Journal of Information Management,37(2), 14-24.   
Ling,E.C.,Tusyadiah,I.,Tuomi,A.,Stienmetz,J.,& loannou,A. (021). Factors influencing users'adoption and use of conversational agents:A systematic review.Psychology& Markteing，38(7), 1031-1051.   
Lobschat，L.，Mueller，B.，Eggers，F.，Brandimarte，L.，Diefenbach，S., Kroschke,M.，& Wirtz, J.(2021). Corporate digital responsibility. Journal of Business Research,122,875-888.   
Lounsbury,M.(1997).Exploring the institutional tool kit:The rise of recycling in the US solid waste field.American Behavioral Scientist, 40(4),465-477.   
Lu,V.N.,Wirtz,J.,Kunz,W.H.,Paluch,S.,Gruber,T.，Martins,A.，& Patterson，P.G.(202O).Service robots，customers and service employees:What can we learn from the academic literature and where are the gaps? Journal of Service Theory and Practice,30(3), 361-391.   
Maclnnis,D.J.,Morwitz,V.G.,Boti,S., Hoffman, D.L.,Kozinets,R.V., Lehmann,D.R.，Lynch,J.G.,& Pechmann,C.(2020).Creating boundary-breaking，marketing-relevant consumer research.Journal of Marketing,84(2),1-23.   
Madigan,R.,Louw,T.,Wilbrink,M., Schieben,A.,& Merat,N. (2017). What influences the decision to use automated public transport? Using UTAUT to understand public acceptance of automated road transport systems.Transportation Research PartF:Traffic Psychology and Behavior,50,55-64.   
Maiers,J.,& Sherif,Y.S.(1985).Applications of fuzzy set theory.IEEE Transactions on Systems,Man and Cybernetics,SMC-15(1),175-189.   
Makridakis，S. (2017)．The forthcoming Artificial Intelligence (Al) revolution: Its impact on society and firms. Futures,90,46-60.   
Malter,M.S., Holbrook,M.B.,Kahn, B.E., Parker,J.R.,& Lehmann,D.R. (2020).The past，present，and future of consumer research. Marketing Letters,31(2),137-149.   
Mariani,M.,& Borghi,M.(2019). Industry 4.O:A bibliometric review of its managerial intellectual structure and potential evolution in the service industries.Technological Forecasting and Social Change, 149(12), 119752.   
Mariani,M.M.,Al-Sultan,K.,& De Massis,A.(2021).Corporate social responsibility in family firms:A systematic literature review.Journal ofSmall Business Management，1-55.https://doi.org/10.1080/ 00472778.2021.1955122   
Mariani, M.,& Baggio,R. (2021). Big data and analytics in hospitality and tourism:a systematic literature review.International Journal of Contemporary Hospitality Management, https://doi.org/1O.1108/ JCHM-03-2021-0301   
Mariani,M.,& Borghi,M.(2021).Customers'evaluation of mechanical artificial intelligence in hospitality services:a study using online reviews analytics.International Journal of Contemporary Hospitality Management, 33(11),3956-3976.   
Marketing Science Institute (202O).Research Priorities:2020-2022 [report]. Available at: https://www.msi.org/wp-content/uploads/ 2021/07/MSl-2020-22-Research-Priorities-final.pdf-WORD.pdf   
Marshall,A.(2O18).Is this the world's first good robot album? BBC Culture [website].Available at: https://www.bbc.com/culture/ article/20180112-is-this-the-worlds-first-good-robot-album   
Martin-Martin,A.,Orduna-Malea,E.,Thelwall,M.,& López-Cózar,E.D. (2018). Google Scholar,Web of Science,and Scopus: A systematic comparison of citations in 252 subject categories.Journal of Informetrics,12(4),1160-1177.   
Martynov,I.,Klima-Frysch,J.,& Schoenberger,J.(202O).A scientometric analysis of neuroblastoma research.BMC cancer,20,1-10.   
Mathur,M.B.,& Reichling,D.B.(2O16).Navigatinga social world with robot partners:A quantitative cartography of the Uncanny Valley. Cognition,146,22-32.   
Matsui,A.(2ooO). Expected utility and case-based reasoning. Mathematical Social Sciences,39(1),1-12.   
McCarthy，J.,Minsky，M.，Rochester，N.，& Shannon,C.E.(2006).A proposal for the dartmouth summer research project on artificial intelligence. Al Magazine,27(4),12-14. http://raysolomonoff.com/ dartmouth/boxa/dart564props.pd   
Miller,T. (2O19).Explanation in artificial intelligence: Insights from the social sciences.Artificial Intelligence,267,1-38.   
Moriuchi，E. (2021).An empirical study on anthropomorphismand engagement with disembodied Alsand consumers're-use behavior.Psychology& Marketing,38(1),21-42.   
Mustak,M.,Salminen,J.,Ple,L.,&Wirtz,J.(2021).Artificial inteligence in marketing: Topic modeling，scientometric analysis，and research agenda.Journal of Business Research,124(1),389-404.   
Netzer,O.,Feldman,R.,Goldenberg,J.,& Fresko,M.(2012).Mine your own business: Market-structure surveillance through text mining. Marketing Science,31(3),521-543.   
O'Toole,A.J., Roark, D.A.,& Abdi, H.(2O02). Recognizing moving faces: A psychological and neural synthesis. Trends in Cognitive Sciences,6(6), 261-266.   
Osbeck,L. M. (2oo9).Transformations in cognitive science: Implications and issues posed.Journalof Theoretical and Philosophical Psychology, 29(1), 16-33.   
Osborne,M.J.(2004).An introduction to game theory (Vol.3).Oxford University Press.   
Paluch,S.,& Wirtz,J.(2O2O).Artificial inteligence and robots in the service encounter.Journal of service management research,4,3-8.   
Park,S.S.,Tung,C.D.,& Lee,H.(2021).The adoption of Al service robots: A comparison between credence and experience service settings. Psychology & Marketing,38(4),691-703.   
Paul,J.,& Criado,A. R.(2O2O).The art of writing literature review: What do we know and what do we need to know? International Business Review,29(4),1-7.   
Paul,J.,& Feliciano-Cestero,M.M. (2021).Five decades of research on foreign direct investment by MNEs:An overview and research agenda. Journal of Business Research,124(1),800-812.   
Pennebaker，J.W.，Mehl，M．R.，& Niederhoffer，K.G．(2003). Psychological aspects of natural language use:Our words,our selves.Annual Review of Psychology,54(1),547-577.   
Perez-Vega,R., Kaartemo,V., Lages, C. R.，Razavi, N. B.,& Männisto,J. (2021).Reshaping the contexts of online customer engagement behavior via artificial intelligence:A conceptual framework.Journal of Business Research,129(5),902-910.   
Perianes-Rodriguez,A.,Waltman,L.,& van Eck,N.J. (2O16). Constructing bibliometric networks:A comparison between full and fractional counting.Journal of Informetrics,10(4),1178-1195.   
Perri，C.，Giglio，C.，& Corvello，V.(202O).Smart users for smart technologies: Investigating the intention to adopt smart energy consumption behaviors.Technological Forecasting and Social Change, 155,119991.   
Perry,C., Ziegler,J.C.,& Zorzi, M. (20o7). Nested incremental modeling in the development of computational theories:The $\mathsf { C D P + }$ model of reading aloud. Psychological Review,114(2),273.   
Phan,D.D.,& Vogel,D.R.(2010).A model of customer relationship management and business intelligence systems for catalogue and online retailers.Information & Management,47(2),69-77.   
Piattelli-Palmarini,M. (1989).Evolution,selection and cognition: From "learning”to parameter setting in biology and in the study of language. Cognition,31(1),1-44.   
Pickering,C.,& Byrne,J. (2014).The benefits of publishing systematic quantitative literature reviews for PhD candidates and other earlycareer researchers. Higher Education Research & Development, 33(3), 534-548.   
Pillai, R.,& Sivathanu,B. (202O).Adoption of internet of things (loT) in the agriculture industry deploying the BRT framework. Benchmarking, 27(4), 1341-1368.   
Pitardi，D.，Meloni，D.，Olivo，F.，Loprevite，D.，Cavarretta，M.C., Behnisch,P.,Brouwer,A.,Felzel,E., Ingravalle,F., Capra,P.,Gili,M., Pezzolato,M.,& Bozzetta,E.(2021). Alexa,she's not human but. Unveiling the drivers of consumers' trust in voice-based artificial intelligence.Psychology& Marketing,38(4),626-642.   
Pitardi,V., Wirtz,J., Paluch,S.,& Kunz,W. (2O21).Service robots,agency, and embarrassing service encounters.Journal of Service Management. 1-26. https://doi.0rg/10.1108/JOSM-12-2020-0435   
Posner,M.I.,& Rothbart,M.K.(2oo7). Research on attention networks as a model for the integration of psychological science.Annual Review of Psychology,58(1),1-23.   
Poushneh,A. (2O21).Humanizing voice assistant:The impact of voice assistant personality on consumers'attitudes and behaviors.Journal of Retailing and Consumer Services, 58(1),1-10.   
Pritchard,A. (1969).Statistical bibliography or bibliometrics. Journal of Documentation,25(4),348-349.   
Protopapas,A. (1999). Connectionist modeling of speech perception. Psychological Bulletin,125(4),410-436.   
Puntoni, S., Reczek,R.W.,Giesler,M.,& Botti, S.(2O21). Consumers and artificial intelligence:An experiential perspective.Journal of Marketing,85(1),131-151.   
Pylyshyn,Z. (1999). Is vision continuous with cognition?:The case for cognitive impenetrability of visual perception. Behavioral and Brain Sciences,22(3),341-365.   
Quackenbush, C.(2018).A Painting Made by Artificial Inteligence Has Been Sold at Auction for $\$ 432,500$ ．Time Magazine [website]. Availableat:https://time.com/5435683/artificial-intellgencepainting-christies/   
Radhakrishnan,S.,Erbis,S.,Isaacs,J.A,& Kamarthi,S. (2017).Correction: Novel keyword co-occurrence network-based methods to foster systematic reviews ofscientific literature.PLOS One，12(9), e0185771.   
Rahwan,I.,Cebrian,M.，Obradovich,N.，Bongard,J.，Bonnefon,J.F., Breazeal,C.，Crandall，J.W.，Christakis，N．A.，Couzin，I．D., Jackson，M.O.，Jennings，N.R.，Kamar，E.，Larochelle,I.M.H., Lazer,D.,McElreath,R.,Mislove,A.,Parkes, D.C.,Pentland,A.S., Roberts,M.E.,.. Wellman, W. (2019).“Machine behaviour". Nature, 568(7753),477-486.   
Raijmakers，M.E.，& Molenaar，P.C. (2004).Modeling developmental transitions in adaptive resonance theory. Developmental science,7(2), 149-157.   
Rangaswamy,A.,Moch,N.,Felten,C.,van Bruggen,G.,Wiering,J.E.,& Wirtz,J. (202O).The role of marketing in digital business platforms. Journal of Interactive Marketing,51,72-90.   
Rayome,A.D.(2019).The 10 most in-demand Al jobs in the world. https:// www.techrepublic.com/article/the-10-most-in-demand-ai-jobs-inthe-world/   
Reyna,V.F.,& Casillas,W.(2oo9).Development and dual processes in moral reasoning:A fuzzy-trace theory approach.Psychology of Learning and Motivation,50,207-236.   
Rokka,J.(2O21).Consumer Culture Theory's future in marketing.Journal of Marketing Theory and Practice,29(1),114-124.   
Rothbart,M.K. (2O07). Temperament, development，and personality. Current directions in psychological science,16(4),207-212.   
Rygielski, C.,Wang,J.C.,& Yen,D.C.(2O02). Data mining techniques for customer relationship management.Technology in society，24(4), 483-502.   
Salminen,J.,Yoganathan,V., Corporan,J., Jansen,B.J.，& Jung,S.G. (2019). Machine learning approach to auto-tagging online content for content marketing efficiency:A comparative analysis between methods and content type.Journal of Business Research,101(8), 203-217.   
Schlesinger, M.(2O04). Evolving agents as a metaphor for the developing child. Developmental science,7(2),158-164.   
Shankar,V. (2O18).Howartificial intelligence (Al) isreshapingretailing. Journal of Retailing,94(4),vi-xi.   
Shaw,M.J.,Subramaniam,C.，Tan,G.W.，& Welge，M.E.(2001). Knowledge management and data mining for marketing. Decision Support Systems,31(1),127-137.   
Shirzad,N.,& Van der Loos,H.M.(2O16).Evaluating the user experience of exercising reaching motions with a robot that predicts desired movement difficulty.Journal of Motor Behavior,48(1),31-46.   
Shultz,T.R.,& Lepper,M.R.(1996).Cognitive dissonance reduction as constraint satisfaction.Psychological Review,103(2),219-240.   
Sivatnanu, B.(∠UI8).Aaoption or Internet or tnings (IUI) Dasea wearabies for healthcare of older adults-a behavioural reasoning theory (BRT) approach.Journal of Enabling Technologies,12(4),169-185.   
Snyder，H. (2019).Literature review as a research methodology: An overview and guidelines.Journal of Business Research，104(11), 333-339.   
Steele,G.R. (2OO2). Hayek's sensory order.Theory& Psychology,12(3), 387-409.   
Sterne,J. (2O17).Artificial inteligence for marketing: Practical applications. John Wiley & Sons   
Su,H.N.,& Lee,P.C.(201O).Mapping knowledge structure by keyword co-occurrence: a first look at journal papers in technology foresight. Scientometrics,85(1),65-79.   
Swenson,R. (1997). Evolutionary theory developing: The problem (s) with Darwin's dangerous idea. Ecological Psychology,9(1),47-96.   
Syam,N.,& Sharma,A. (2O18).Waiting for a sales renaissance in the fourthindustrial revolution:Machine learning and artificial intelligence insales researchandpractice.Industrial Marketing Management,69,135-146.   
Tan,G.W.H.,Ooi,K.B., Leong,L.Y.,& Lin,B.(2014).Predicting the drivers of behavioral intention to use mobile learning: A hybrid SEMNeural Networks approach.Computers in Human Behavior，36, 198-213.   
Tan,K.H.,& Lim,B.P. (2O18).The artificial inteligence renaissance: Deep learning and the road to human-level machine intelligence. APSIPA Transactions on Signal and Information Processing,7,1-19.   
Tay,B., Jung,Y.,& Park,T.(2014).When stereotypes meet robots: The double-edge sword of robot gender and personality in human-robot interaction. Computers in Human Behavior,38(9),75-84.   
Teng,S., Khong, K.W.,& Ha,N.C. (202O).Palm oil and its environmental impacts:A big data analytics study.Journal of Cleaner Production, 274, 122901.   
Thagard,P.(1989).Explanatory coherence.Behavioral and Brain Sciences, 12(3),435-467.   
Tranfield, D.,Denyer,D.,& Smart,P. (2Oo3).Towards a methodology for developing evidence-informed management knowledge by means of systematic review. British Journal of Management,14(3),207-222.   
Trope,Y.,& Liberman,N. (2O1O). Construal-level theory of psychological distance.Psychological Review,117(2),440-463.   
Tufekci,Z.(2O15).The Machines are Coming [website].Available at: https://www.nytimes.com/2015/04/19/opinion/sunday/the-machinesare-coming.html   
Turban,E.,Sharda,R,Aronson,J.E.,&King,D.(2Oo8).Business inteligence:A managerial approach (pp.58-59).Pearson Prentice Hall.   
UNCTAD.(2021).Technologyandinnovationreport2021:Catching technological waves-Innovation with equity.New York: United Nations.   
Van Doorn，J.，Mende，M.，Noble，S.M.，Hulland,J.，Ostrom，A.L, Grewal,D.，& Petersen,J.A. (2017).Domo arigato Mr.Roboto: Emergence of automated social presence in organizational frontlines and customers'service experiences.Journal of Service Research, 20(1),43-58.   
Van Oost,E.,& Reed,D. (2010,June).Towards a sociological understanding of robots as companions.International Conference on Human-Robot Personal Relationship(pp.11-18).Springer,Berlin,Heidelberg   
Van Eck，N.，& Waltman,L. (2OO9).Software survey:VOSviewer，a computer program for bibliometric mapping.Scientometrics,84(2), 523-538.   
Van Eck,N.J.,Waltman,L.,Dekker,R.，& van den Berg,J.(2010).A comparisonoftwotechniquesforbibliometricmapping: Multidimensional scaling and VOS.Journal of the American Society for Information Science and Technology,61(12),2405-2416.   
Vandemeulebroucke,T.,de Casterlé, D.B.,& Gastmans,C.(2018).The use of care robots in aged care:A systematic review of argumentbased ethics literature.Archives of Gerontology and Geriatrics,74, 15-25.   
Vargo,S.L.，& Koskela-HuotarI， K. (2U2U). Advancing conceptual-only articles in marketing.Academy of Marketing Science Review,10(1-2), 1-84.   
Venkatesh, V.(20o0). Determinants of perceived ease of use: Integrating control,intrinsicmotivation，andemotioninto thetechnology acceptance model.Information Systems Research,11(4),342-365.   
Venkatesh,V.,Thong,J.Y.,& Xu,X.(2016). Unified theory of acceptance and use of technology: A synthesis and the road ahead.Journal of the Association for Information Systems,17(5),328-376.   
Vlacic,B., Corbo,L.,e Silva,S.C.,& Dabic,M.(2021).The evolving role of artificial inteligence in marketing:A review and research agenda. Journal of Business Research,128,187-203.   
Wang,X.,White,L.,Chen,X.,Gao,Y.,Li, H.,& Luo,Y.(2015).An empirical study of wearable technology acceptance in healthcare. Industrial Management& Data Systems,115(9),1704-1723.   
Wedel,M.，& Kannan,P.K. (2016).Marketing analytics for data-rich environments. Journal of Marketing,80(6),97-121.   
Westaby，J.D.(2Oo5)． Behavioral reasoning theory: Identifying new linkagesunderlyingintentionsandbehavior.Organizational behavior and human decision processes,98(2),97-120.   
West,R.L.，& Lebiere,C. (2O01). Simple games as dynamic,coupled systems:Randomness and other emergent properties.Cognitive Systems Research,1(4),221-239.   
Wilson，M. (1988).MRC psycholinguistic database:Machine-usable dictionary,version 2.O0.Behavior Research Methods,Instruments，& Computers,20(1), 6-10.   
Wirtz,J.，den Ambtman,A.， Bloemer,J.,Horvath,C.，Ramaseshan,B., Van De Klundert,J., Canli,Z.G.,& Kandampuly,J. (2013). Managing brands and customer engagement in online brand communities. Journal of Service Management,24(3),223-244.   
Wirtz,J.,Hartley,N.,Kunz,W.,Tarbit,J.,& Ford,J.(2O21).Corporate digital responsibility at the dawn of the digital service revolution. SSRN Electronic Journal. https://doi.org/10.2139/ssrn.3806235   
Wirtz,J.,Patterson,P.G.,Kunz,W. H.,Gruber,T.,Lu,V.N.,Paluch,S.,& Martins,A. (2O18). Brave new world: Service robots in the frontline. Journal of Service Management,29(5),907-931.   
Wirtz,J.,& Zeithaml, V. (2018). Cost-effective service excellence.Journal of the Academy of Marketing Science,46(1),59-80.   
Wu,J.,Li，H.，Cheng，S.，& Lin，Z. (2O16).The promising future of healthcare services:When big data analytics meets wearable technology.Information & Management,53(8),1020-1033.   
Xiang,Z., Du,Q.,Ma,Y.,& Fan,W. (2017).A comparative analysis of major online review platforms: Implications for social media analytics in hospitality and tourism.Tourism Management,58,51-65.   
Xiang,Z., Schwartz,Z.,Gerdes,J.H., Jr.,& Uysal,M. (2015).What can big data and text analytics tell us about hotel guest experience and Satisfaction? International Journal of Hospitality Management，44, 120-130.   
Xu,Z., Frankwick,G.L.,& Ramirez,E.(2O16).Effects of big data analytics and traditional marketing analytics on new product success:A knowledge fusion perspective.Journal of Business Research,69(5), 1562-1566.   
Yarkoni,T.,& Westfal,J. (2O17). Choosing prediction over explanation in psychology: Lessons from machine learning.Perspectiveson Psychological Science,12(6),1100-1122.   
Zhang,Q.,Lu,J.,& Jin,Y. (2O21).Artificial inteligence in recommender systems. Complex& Intelligent Systems,7(1),439-457.   
Zhao,D.,& Strotmann,A. (2O15).Analysis and visualization of citation networks.Synthesis Lectures on Information Concepts, Retrieval,and Services,7(1),1-207.   
Zimmermann，H.J. (2O1O). Fuzzy set theory.Wiley Interdisciplinary Reviews: Computational Statistics,2(3),317-332.   
Zollet,R.(2O14). Interactivity of corporate websites:An integrative review of the literature.IEEE Transactions on Professional Communication, 57(1). 2-16.

Zupic,I.，& Cater，T. (2015).Bibliometric methods in management andorganization. OrganizationalResearchMethods, 18(3), 429-472.

# SUPPORTING INFORMATION

Additional supporting information may be found in the online version of the article at the publisher's website.

How to cite this article: Mariani, M. M., Perez-Vega, R.,& Wirtz,J.(2022).Al in marketing,consumer research and psychology:A systematic literature review and research agenda.Psychology&Marketing,39,755-776. https://doi.org/10.1002/mar.21619